/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.networking;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import thelm.packagedauto.integration.appeng.networking.HostHelperTile;
import thelm.packagedauto.tile.TileUnpackager;

public class HostHelperTileUnpackager
extends HostHelperTile<TileUnpackager> {
    public HostHelperTileUnpackager(TileUnpackager tile) {
        super(tile);
    }

    public void chargeEnergy() {
        IGrid grid = this.getNode().getGrid();
        if (grid == null) {
            return;
        }
        IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        if (energyGrid == null) {
            return;
        }
        double energyRequest = (double)Math.min(((TileUnpackager)this.tile).getEnergyStorage().getMaxReceive(), ((TileUnpackager)this.tile).getEnergyStorage().getMaxEnergyStored() - ((TileUnpackager)this.tile).getEnergyStorage().getEnergyStored()) / 2.0;
        double canExtract = energyGrid.extractAEPower(energyRequest, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        double extract = (double)Math.round(canExtract * 2.0) / 2.0;
        ((TileUnpackager)this.tile).getEnergyStorage().receiveEnergy((int)Math.round(energyGrid.extractAEPower(extract, Actionable.MODULATE, PowerMultiplier.CONFIG) * 2.0), false);
    }

    public void postPatternChange() {
        IGrid grid = this.getNode().getGrid();
        if (grid == null) {
            return;
        }
        grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this.tile, this.getNode()));
    }
}

