/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.energy;

import net.minecraft.nbt.NBTTagCompound;
import thelm.packagedauto.network.packet.PacketSyncEnergy;
import thelm.packagedauto.tile.TileBase;

public class EnergyStorage
extends net.minecraftforge.energy.EnergyStorage {
    public final TileBase tile;
    public int prevEnergy;

    public EnergyStorage(TileBase tile, int capacity) {
        this(tile, capacity, capacity, capacity, 0);
    }

    public EnergyStorage(TileBase tile, int capacity, int maxTransfer) {
        this(tile, capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorage(TileBase tile, int capacity, int maxReceive, int maxExtract) {
        this(tile, capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorage(TileBase tile, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.tile = tile;
    }

    public EnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    public EnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public EnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public EnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public EnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        boolean flag = !this.tile.func_145831_w().field_72995_K && this.energy != energy;
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void updateIfChanged() {
        int currentEnergy = this.getEnergyStored();
        if (!this.tile.func_145831_w().field_72995_K && this.prevEnergy != currentEnergy) {
            PacketSyncEnergy.syncEnergy(this.tile.func_174877_v(), currentEnergy, this.tile.func_145831_w().field_73011_w.getDimension(), 8.0);
            this.tile.func_70296_d();
        }
        this.prevEnergy = currentEnergy;
    }
}

