/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity.spawner;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.boss.IBossCapability;
import twilightforest.enums.BossVariant;
import twilightforest.events.BossEvent;

public abstract class TileEntityTFBossSpawner
extends TileEntity
implements ITickable {
    protected static final int SHORT_RANGE = 9;
    protected static final int LONG_RANGE = 50;
    private final BossVariant variant;
    protected final ResourceLocation mobID;
    protected Entity displayCreature = null;
    protected boolean spawnedBoss = false;
    private EntityLivingBase living = null;
    private int renderTick = 0;

    protected TileEntityTFBossSpawner(ResourceLocation mobID, BossVariant variant) {
        this.mobID = mobID;
        this.variant = variant;
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.getRange());
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    public void func_73660_a() {
        boolean check;
        if (this.spawnedBoss) {
            return;
        }
        boolean playerCheck = this.anyPlayerInRange();
        if (this.field_145850_b.field_72995_K) {
            if (this.renderTick == 1800) {
                this.renderTick = 0;
            }
            ++this.renderTick;
            if (playerCheck) {
                double rx = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                double ry = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                double rz = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, rx, ry, rz, 0.0, 0.0, 0.0, new int[0]);
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, rx, ry, rz, 0.0, 0.0, 0.0, new int[0]);
            }
            return;
        }
        if (this.living == null) {
            this.living = this.makeMyCreature();
        }
        if (this.living == null) {
            return;
        }
        BossEvent.Spawning event = new BossEvent.Spawning(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this, this.living);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Event.Result result = event.getResult();
        if (result == Event.Result.DENY) {
            return;
        }
        boolean bl = check = result == Event.Result.ALLOW || playerCheck;
        if (check) {
            if (this.field_145850_b.func_175659_aa() == EnumDifficulty.PEACEFUL && this.living instanceof IMob) {
                return;
            }
            if (!this.field_145850_b.field_72995_K && this.spawnMyBoss(this.living)) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
                this.spawnedBoss = true;
                this.living = null;
            }
        }
    }

    protected boolean spawnMyBoss(EntityLivingBase myCreature) {
        myCreature.func_174828_a(this.field_174879_c, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (myCreature instanceof EntityLiving) {
            ((EntityLiving)myCreature).func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
        }
        this.initializeCreature(myCreature);
        return this.field_145850_b.func_72838_d((Entity)myCreature);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderTick() {
        return this.renderTick;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getDisplayEntity() {
        if (this.displayCreature == null) {
            this.displayCreature = this.makeMyCreature();
        }
        return this.displayCreature;
    }

    protected void initializeCreature(EntityLivingBase myCreature) {
        if (myCreature instanceof EntityCreature) {
            ((EntityCreature)myCreature).func_175449_a(this.field_174879_c, 46);
        }
    }

    public int getRange() {
        return 9;
    }

    @Nullable
    protected EntityLivingBase makeMyCreature() {
        EntityLivingBase living = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)this.mobID, (World)this.field_145850_b);
        BossEvent.Construction event = new BossEvent.Construction(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this, living);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getModifiedBoss() == null) {
            return living;
        }
        living = event.getModifiedBoss();
        if (living == null) {
            return null;
        }
        if (!this.field_145850_b.field_72995_K) {
            IBossCapability capability = (IBossCapability)living.getCapability(CapabilityList.BOSS, null);
            if (capability == null) {
                return living;
            }
            capability.setBossVariant(this.variant);
            capability.setHomePos(this.field_174879_c);
        }
        return living;
    }
}

