/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.scepter;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import twilightforest.item.scepter.ItemTFScepter;

public class ItemTFScepterLifeDrain
extends ItemTFScepter {
    public ItemTFScepterLifeDrain(EnumRarity rarity, int damage) {
        super(rarity, damage);
    }

    private void spawnRedParticles(World world, double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double tx = srcX + (destX - srcX) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + world.field_73012_v.nextGaussian() * 0.005;
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, tx, ty, tz, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    protected void spawnShatteringParticles(World world, EntityLivingBase target) {
        int itemId = Item.func_150891_b((Item)Items.field_151078_bh);
        for (int i = 0; i < 50; ++i) {
            double gaussX = field_77697_d.nextGaussian() * 0.02;
            double gaussY = field_77697_d.nextGaussian() * 0.02;
            double gaussZ = field_77697_d.nextGaussian() * 0.02;
            double gaussFactor = 10.0;
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, target.field_70165_t + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - gaussX * gaussFactor, target.field_70163_u + (double)(field_77697_d.nextFloat() * target.field_70131_O) - gaussY * gaussFactor, target.field_70161_v + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - gaussZ * gaussFactor, gaussX, gaussY, gaussZ, new int[]{itemId});
        }
    }

    @Override
    public Item getRepairItem(ItemStack stack) {
        return Items.field_151071_bq;
    }

    private float getMaxHealth(EntityLivingBase target) {
        return (float)target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        Entity pointedEntity;
        World world = living.field_70170_p;
        if (stack.func_77952_i() >= this.getMaxDamage(stack)) {
            living.func_184602_cy();
            return;
        }
        if (count % 5 == 0 && (pointedEntity = this.getEntityTarget(world, living)) != null && pointedEntity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)pointedEntity;
            if (target.func_70660_b(MobEffects.field_76421_d) != null || target.func_110143_aJ() < 1.0f) {
                if (target.func_110143_aJ() <= 3.0f) {
                    this.spawnRedParticles(world, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
                    if (target instanceof EntityLiving) {
                        ((EntityLiving)target).func_70656_aK();
                    }
                    target.func_184185_a(SoundEvents.field_187655_bw, 1.0f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.spawnShatteringParticles(world, target);
                    if (!world.field_72995_K) {
                        target.func_70106_y();
                        target.func_70645_a(DamageSource.func_76354_b((Entity)living, (Entity)living));
                    }
                    living.func_184602_cy();
                } else if (!world.field_72995_K) {
                    target.func_70097_a(DamageSource.func_76354_b((Entity)living, (Entity)living), 3.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth(living)) {
                        target.field_70159_w = 0.0;
                        target.field_70181_x = 0.2;
                        target.field_70179_y = 0.0;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 2));
                    if (count % 10 == 0) {
                        living.func_70691_i(1.0f);
                        if (living instanceof EntityPlayer) {
                            ((EntityPlayer)living).func_71024_bL().func_75122_a(1, 0.1f);
                        }
                    }
                }
            } else {
                this.spawnRedParticles(world, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
                living.func_184185_a(SoundEvents.field_187649_bu, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                if (!world.field_72995_K) {
                    target.func_70097_a(DamageSource.func_76354_b((Entity)living, (Entity)living), 1.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth(living)) {
                        target.field_70159_w = 0.0;
                        target.field_70181_x = 0.2;
                        target.field_70179_y = 0.0;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 2));
                }
            }
            if (!world.field_72995_K) {
                stack.func_77972_a(1, living);
            }
        }
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BOW;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() == newStack.func_77973_b();
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }
}

