/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import twilightforest.compat.groovyscript.GSPlugin;
import twilightforest.item.ItemTFTransformPowder;

@RegistryDescription(linkGenerator="twilightforest")
public class Transformation
extends VirtualizedRegistry<TransformationRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".input(entity('minecraft:mooshroom')).output('minecraft:cow')"), @Example(value=".input(resource('minecraft:polar_bear'), resource('minecraft:rabbit').twoWay()")})
    public EntityRecipeBuilder entityBuilder() {
        return new EntityRecipeBuilder();
    }

    @RecipeBuilderDescription(example={@Example(value=".input(block('minecraft:stone')).output(blockstate('minecraft:dirt'))"), @Example(value=".input(block('minecraft:iron_block')).output(block('minecraft:gold_block'))"), @Example(value=".input(item('minecraft:planks')).predicate(s -> s.getBlock().getMetaFromState(s) == 0).output(item('minecraft:planks:1'))"), @Example(value=".input(item('minecraft:planks')).predicate(3, 4).output(item('minecraft:planks:3'))"), @Example(value=".input(item('minecraft:planks')).predicate(blockstate('minecraft:planks:5'), blockstate('minecraft:planks:6')).output(item('minecraft:planks:4'))")})
    public BlockRecipeBuilder blockBuilder() {
        return new BlockRecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        this.removeScripted().forEach(TransformationRecipe::onRemove);
        this.restoreFromBackup().forEach(TransformationRecipe::onRestore);
    }

    public Transformation() {
        super((Collection)Lists.newArrayList((Object[])new String[]{"transformation", "Transformation", "transformationpowder", "transformation_powder", "TransformationPowder"}));
    }

    public void add(TransformationRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            recipe.onRestore();
        }
    }

    public boolean remove(TransformationRecipe recipe) {
        if (recipe != null) {
            this.addBackup(recipe);
            return recipe.onRemove();
        }
        return false;
    }

    public void addEntity(EntityEntry input, EntityEntry output) {
        ResourceLocation in = input.getRegistryName();
        ResourceLocation out = output.getRegistryName();
        if (in == null || out == null) {
            return;
        }
        this.addEntity(in, out);
    }

    public void addEntity(ResourceLocation input, ResourceLocation output) {
        EntityTransformation recipe = new EntityTransformation(input, output, false);
        this.add(recipe);
    }

    public void addBlock(Block input, Predicate<IBlockState> inputPredicate, IBlockState output) {
        BlockTransformation recipe = new BlockTransformation(input, inputPredicate, output);
        this.add(recipe);
    }

    public void addBlock(Block input, IBlockState output) {
        this.addBlock(input, null, output);
    }

    public void addBlock(Block input, IBlockState output, int ... metas) {
        this.addBlock(input, (IBlockState s) -> {
            for (int m : metas) {
                if (output.func_177230_c().func_176201_c(output) != m) continue;
                return true;
            }
            return false;
        }, output);
    }

    public void addBlock(IBlockState input, IBlockState output) {
        this.addBlock(input.func_177230_c(), (IBlockState s) -> s == input, output);
    }

    public void addBlock(ItemStack input, Predicate<IBlockState> inputPredicate, ItemStack output) {
        Block iBlock = Transformation.getBlock(input);
        Block oBlock = Transformation.getBlock(output);
        if (iBlock == Blocks.field_150350_a || oBlock == Blocks.field_150350_a) {
            return;
        }
        IBlockState state = oBlock.func_176203_a(output.func_77973_b().func_77647_b(output.func_77960_j()));
        this.addBlock(iBlock, inputPredicate, state);
    }

    public void addBlock(ItemStack input, ItemStack output) {
        this.addBlock(input, (IBlockState s) -> input.func_77960_j() == Short.MAX_VALUE || s.func_177230_c().func_176201_c(s) == input.func_77960_j(), output);
    }

    public void addBlock(ItemStack input, ItemStack output, int ... metas) {
        this.addBlock(input, (IBlockState s) -> {
            for (int m : metas) {
                if (output.func_77973_b().func_77647_b(output.func_77960_j()) != m) continue;
                return true;
            }
            return false;
        }, output);
    }

    public void addTwoWayEntity(EntityEntry input, EntityEntry output) {
        ResourceLocation in = input.getRegistryName();
        ResourceLocation out = output.getRegistryName();
        if (in == null || out == null) {
            return;
        }
        this.addTwoWayEntity(in, out);
    }

    public void addTwoWayEntity(ResourceLocation input, ResourceLocation output) {
        EntityTransformation recipe = new EntityTransformation(input, output, true);
        this.add(recipe);
    }

    public boolean removeEntity(EntityEntry input) {
        ResourceLocation in = input.getRegistryName();
        if (in == null) {
            return false;
        }
        return this.removeEntity(in);
    }

    public boolean removeEntity(ResourceLocation input) {
        ResourceLocation out = ItemTFTransformPowder.getTransformationEntity(input);
        EntityTransformation recipe = new EntityTransformation(input, out, false);
        return this.remove(recipe);
    }

    public boolean removeTwoWayEntity(EntityEntry input) {
        ResourceLocation in = input.getRegistryName();
        if (in == null) {
            return false;
        }
        return this.removeTwoWayEntity(in);
    }

    public boolean removeTwoWayEntity(ResourceLocation input) {
        ResourceLocation out = ItemTFTransformPowder.getTransformationEntity(input);
        EntityTransformation recipe = new EntityTransformation(input, out, true);
        return this.remove(recipe);
    }

    public void removeAll() {
        ArrayList recipes = new ArrayList(ItemTFTransformPowder.getTransformMap().size());
        ItemTFTransformPowder.getTransformMap().forEach((key, value) -> recipes.add(new EntityTransformation((ResourceLocation)key, (ResourceLocation)value, false)));
        recipes.forEach(this::remove);
    }

    public SimpleObjectStream<TransformationRecipe> streamRecipes() {
        return new SimpleObjectStream(Transformation.getAllRecipes()).setRemover(this::remove);
    }

    private static List<TransformationRecipe> getAllRecipes() {
        ArrayList<TransformationRecipe> recipes = new ArrayList<TransformationRecipe>(ItemTFTransformPowder.getTransformMap().size() + ItemTFTransformPowder.getTransformBlockMap().size());
        ItemTFTransformPowder.getTransformMap().forEach((k, v) -> recipes.add(new EntityTransformation((ResourceLocation)k, (ResourceLocation)v, false)));
        ItemTFTransformPowder.getTransformBlockMap().forEach((k, v) -> recipes.add(new BlockTransformation((Block)k, (Predicate)v.getKey(), (IBlockState)v.getValue())));
        return recipes;
    }

    protected static Block getBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        if (stack.func_77973_b() instanceof ItemBlockSpecial) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    public static class BlockTransformation
    extends TransformationRecipe {
        private final Block block;
        private final Predicate<IBlockState> predicate;
        private final IBlockState state;

        public BlockTransformation(Block block, Predicate<IBlockState> predicate, IBlockState state) {
            this.block = block;
            this.predicate = predicate;
            this.state = state;
        }

        @Override
        public void onRestore() {
            if (this.predicate != null) {
                ItemTFTransformPowder.addBlockTransformation(this.block, this.predicate, this.state);
            } else {
                ItemTFTransformPowder.addBlockTransformation(this.block, this.state);
            }
        }

        @Override
        public boolean onRemove() {
            return ItemTFTransformPowder.getTransformBlockMap().remove(this.block) != null;
        }
    }

    public static class EntityTransformation
    extends TransformationRecipe {
        private final ResourceLocation input;
        private final ResourceLocation output;
        private final boolean twoWay;

        public EntityTransformation(ResourceLocation input, ResourceLocation output, boolean twoWay) {
            this.input = input;
            this.output = output;
            this.twoWay = twoWay;
        }

        @Override
        public void onRestore() {
            if (this.twoWay) {
                ItemTFTransformPowder.addTwoWayTransformation(this.input, this.output);
            } else {
                ItemTFTransformPowder.addOneWayTransformation(this.input, this.output);
            }
        }

        @Override
        public boolean onRemove() {
            if (this.twoWay) {
                boolean out = true;
                out &= ItemTFTransformPowder.removeEntityTransformation(this.input);
                return out &= ItemTFTransformPowder.removeEntityTransformation(this.output);
            }
            return ItemTFTransformPowder.removeEntityTransformation(this.input);
        }
    }

    public static abstract class TransformationRecipe {
        public abstract void onRestore();

        public abstract boolean onRemove();
    }

    public static class BlockRecipeBuilder
    extends AbstractRecipeBuilder<BlockTransformation> {
        private Block input;
        private Predicate<IBlockState> predicate;
        private IBlockState output;

        @RecipeBuilderMethodDescription(field={"input"})
        public BlockRecipeBuilder setInput(Block input) {
            this.input = input;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"input"})
        public BlockRecipeBuilder setInput(ItemStack input) {
            Block block = Transformation.getBlock(input);
            if (block == Blocks.field_150350_a) {
                return this;
            }
            this.input = block;
            this.predicate = input.func_77960_j() == Short.MAX_VALUE ? null : s -> s.func_177230_c().func_176201_c(s) == input.func_77960_j();
            return this;
        }

        @RecipeBuilderMethodDescription(field={"output"})
        public BlockRecipeBuilder setOutput(IBlockState output) {
            this.output = output;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"output"})
        public BlockRecipeBuilder setOutput(Block output) {
            this.output = output.func_176223_P();
            return this;
        }

        @RecipeBuilderMethodDescription(field={"output"})
        public BlockRecipeBuilder setOutput(ItemStack output) {
            Block block = Transformation.getBlock(output);
            if (block == Blocks.field_150350_a) {
                return this;
            }
            this.output = block.func_176203_a(output.func_77973_b().getMetadata(output));
            return this;
        }

        @RecipeBuilderMethodDescription(field={"predicate"})
        public BlockRecipeBuilder setPredicate(Predicate<IBlockState> predicate) {
            this.predicate = predicate;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"predicate"})
        public BlockRecipeBuilder setPredicate(IBlockState ... allowedStates) {
            this.predicate = s -> {
                for (IBlockState state : allowedStates) {
                    if (state != s) continue;
                    return true;
                }
                return false;
            };
            return this;
        }

        public BlockRecipeBuilder addPredicate(IBlockState ... allowedStates) {
            Predicate<IBlockState> addPredicate = s -> {
                for (IBlockState state : allowedStates) {
                    if (state != s) continue;
                    return true;
                }
                return false;
            };
            this.predicate = this.predicate == null ? addPredicate : this.predicate.or(addPredicate);
            return this;
        }

        @RecipeBuilderMethodDescription(field={"predicate"})
        public BlockRecipeBuilder setPredicate(int ... metadatas) {
            this.predicate = s -> {
                for (int meta : metadatas) {
                    if (s.func_177230_c().func_176201_c(s) != meta) continue;
                    return true;
                }
                return false;
            };
            return this;
        }

        public BlockRecipeBuilder addPredicate(int ... metadatas) {
            Predicate<IBlockState> addPredicate = s -> {
                for (int meta : metadatas) {
                    if (s.func_177230_c().func_176201_c(s) != meta) continue;
                    return true;
                }
                return false;
            };
            this.predicate = this.predicate == null ? addPredicate : this.predicate.or(addPredicate);
            return this;
        }

        public BlockRecipeBuilder setPredicateSpecific() {
            this.predicate = s -> s.func_177230_c().func_176201_c(s) == 0;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Twilight Forest block transformation recipe";
        }

        public void validate(GroovyLog.Msg msg) {
        }

        @Nullable
        public BlockTransformation register() {
            if (this.input == null || this.output == null) {
                return null;
            }
            BlockTransformation transformation = new BlockTransformation(this.input, this.predicate, this.output);
            GSPlugin.instance.transformationPowder.add(transformation);
            return transformation;
        }
    }

    public static class EntityRecipeBuilder
    extends AbstractRecipeBuilder<EntityTransformation> {
        private ResourceLocation input;
        private ResourceLocation output;
        private boolean twoWay = false;

        public String getRecipeNamePrefix() {
            return "twilight_forest_transformation_";
        }

        @RecipeBuilderMethodDescription(field={"input"})
        public EntityRecipeBuilder setInput(ResourceLocation input) {
            this.input = input;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"input"})
        public EntityRecipeBuilder setInput(EntityEntry input) {
            return this.setInput(input.getRegistryName());
        }

        @RecipeBuilderMethodDescription(field={"output"})
        public EntityRecipeBuilder setOutput(ResourceLocation output) {
            this.output = output;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"output"})
        public EntityRecipeBuilder setOutput(EntityEntry output) {
            return this.setOutput(output.getRegistryName());
        }

        @RecipeBuilderMethodDescription(field={"twoWay"})
        public EntityRecipeBuilder setTwoWay() {
            this.twoWay = true;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Twilight Forest entity transformation recipe";
        }

        public void validate(GroovyLog.Msg msg) {
        }

        @Nullable
        public EntityTransformation register() {
            if (this.input == null || this.output == null) {
                return null;
            }
            EntityTransformation transformation = new EntityTransformation(this.input, this.output, this.twoWay);
            GSPlugin.instance.transformationPowder.add(transformation);
            return transformation;
        }
    }
}

