/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.crafttweaker.events.boss;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.event.IEventHasResult;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.ZenClass;
import twilightforest.compat.crafttweaker.events.boss.IBossEvent;
import twilightforest.events.BossEvent;

@ZenRegister
@ZenClass(value="mods.twilightforest.event.BossSpawnEvent")
public class BossSpawnEvent
implements IBossEvent,
IEventHasResult {
    private final IWorld world;
    private final IBlockPos pos;
    private final String variant;
    private final IEntityLivingBase boss;
    private String result;

    public BossSpawnEvent(BossEvent.Spawning event) {
        this.world = CraftTweakerMC.getIWorld((World)event.getWorld());
        this.pos = CraftTweakerMC.getIBlockPos((BlockPos)event.getPos());
        this.variant = event.getVariant().func_176610_l();
        this.boss = CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)event.getBoss());
        this.result = event.getResult().name().toLowerCase(Locale.US);
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public IBlockPos getPos() {
        return this.pos;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public IEntityLivingBase getBoss() {
        return this.boss;
    }

    public String getResult() {
        return this.result;
    }

    public void setDenied() {
        this.result = "deny";
    }

    public void setDefault() {
        this.result = "default";
    }

    public void setAllowed() {
        this.result = "allow";
    }
}

