/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.crafttweaker.events;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.event.IEventHandle;
import crafttweaker.api.event.IEventManager;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.util.EventList;
import crafttweaker.util.IEventHandler;
import java.util.Locale;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import twilightforest.compat.crafttweaker.events.boss.BossConstructionEvent;
import twilightforest.compat.crafttweaker.events.boss.BossDeathEvent;
import twilightforest.compat.crafttweaker.events.boss.BossSpawnEvent;
import twilightforest.events.BossEvent;

@ZenRegister
@ZenExpansion(value="crafttweaker.events.IEventManager")
public class CTTFEventManager {
    public static final EventList<BossConstructionEvent> elBossConstruction = new EventList();
    public static final EventList<BossSpawnEvent> elBossSpawn = new EventList();
    public static final EventList<BossDeathEvent> elBossDeath = new EventList();

    @ZenMethod
    public static IEventHandle onBossConstruction(IEventManager manager, IEventHandler<BossConstructionEvent> event) {
        return elBossConstruction.add(event);
    }

    @ZenMethod
    public static IEventHandle onBossSpawn(IEventManager manager, IEventHandler<BossSpawnEvent> event) {
        return elBossSpawn.add(event);
    }

    @ZenMethod
    public static IEventHandle onBossDeath(IEventManager manager, IEventHandler<BossDeathEvent> event) {
        return elBossDeath.add(event);
    }

    @SubscribeEvent
    public static void onBossConstruction(BossEvent.Construction event) {
        if (elBossConstruction.hasHandlers()) {
            BossConstructionEvent e = new BossConstructionEvent(event);
            elBossConstruction.publish((Object)e);
            event.setBoss(CraftTweakerMC.getEntityLivingBase((IEntityLivingBase)e.modifiedBoss));
        }
    }

    @SubscribeEvent
    public static void onBossSpawn(BossEvent.Spawning event) {
        if (elBossSpawn.hasHandlers()) {
            BossSpawnEvent e = new BossSpawnEvent(event);
            elBossSpawn.publish((Object)e);
            event.setResult(Event.Result.valueOf((String)e.getResult().toUpperCase(Locale.US)));
        }
    }

    @SubscribeEvent
    public static void onBossDeath(BossEvent.Death event) {
        if (elBossDeath.hasHandlers()) {
            BossDeathEvent e = new BossDeathEvent(event);
            elBossDeath.publish((Object)e);
            event.setCanceled(e.isCanceled());
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(CTTFEventManager.class);
    }
}

