/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import twilightforest.item.ItemTFTransformPowder;

@ZenRegister
@ZenClass(value="mods.twilightforest.Transformation")
public class CTTransformationPowder {
    @ZenMethod
    public static void addEntityTransformation(IEntityDefinition from, IEntityDefinition to) {
        EntityEntry in = (EntityEntry)from.getInternal();
        EntityEntry out = (EntityEntry)to.getInternal();
        ItemTFTransformPowder.addOneWayTransformation(Objects.requireNonNull(in.getRegistryName()), Objects.requireNonNull(out.getRegistryName()));
    }

    @ZenMethod
    public static void addEntityTransformation(String from, String to) {
        ItemTFTransformPowder.addOneWayTransformation(new ResourceLocation(from), new ResourceLocation(to));
    }

    @ZenMethod
    public static void removeEntityTransformation(IEntityDefinition from) {
        EntityEntry in = (EntityEntry)from.getInternal();
        if (!ItemTFTransformPowder.removeEntityTransformation(Objects.requireNonNull(in.getRegistryName()))) {
            CraftTweakerAPI.logError((String)("Could not find transformation for " + from));
        }
    }

    @ZenMethod
    public static void removeEntityTransformation(String from) {
        if (!ItemTFTransformPowder.removeEntityTransformation(new ResourceLocation(from))) {
            CraftTweakerAPI.logError((String)("Could not find transformation for " + from));
        }
    }

    @ZenMethod
    public static void removeAll() {
        ItemTFTransformPowder.removeAll();
    }

    @ZenMethod
    public static void addBlockTransformation(IIngredient from, IItemStack to) {
        ItemStack outStack = CraftTweakerMC.getItemStack((IItemStack)to);
        if (!(outStack.func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Output " + to.toString() + " is not an item of a block"));
            return;
        }
        Block outBlock = ((ItemBlock)outStack.func_77973_b()).func_179223_d();
        int metadata = outStack.func_77973_b().func_77647_b(outStack.func_77960_j());
        IBlockState out = outBlock.func_176203_a(metadata);
        for (IItemStack input : from.getItemArray()) {
            ItemStack inStack = CraftTweakerMC.getItemStack((IItemStack)input);
            if (!(inStack.func_77973_b() instanceof ItemBlock)) {
                CraftTweakerAPI.logError((String)("Input " + input.toString() + " is not an item of a block"));
                continue;
            }
            if (inStack.func_77960_j() == Short.MAX_VALUE) {
                ItemTFTransformPowder.addBlockTransformation(((ItemBlock)inStack.func_77973_b()).func_179223_d(), out);
                continue;
            }
            IBlockState in = ((ItemBlock)inStack.func_77973_b()).func_179223_d().func_176203_a(inStack.func_77973_b().func_77647_b(inStack.func_77960_j()));
            ItemTFTransformPowder.addBlockTransformation(in, out);
        }
    }

    @ZenMethod
    public static void addBlockTransformation(crafttweaker.api.block.IBlockState from, crafttweaker.api.block.IBlockState to) {
        ItemTFTransformPowder.addBlockTransformation(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)from), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)to));
    }

    @ZenMethod
    public static void addBlockTransformation(IBlockDefinition from, crafttweaker.api.block.IBlockState to, int ... metadatas) {
        Block f = CraftTweakerMC.getBlock((IBlockDefinition)from);
        IBlockState t = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)to);
        if (metadatas.length == 0) {
            ItemTFTransformPowder.addBlockTransformation(f, t);
        } else {
            ItemTFTransformPowder.addBlockTransformation(f, (IBlockState state) -> {
                for (int i : metadatas) {
                    if (f.func_176201_c(state) != i) continue;
                    return true;
                }
                return false;
            }, t);
        }
    }

    @ZenMethod
    public static void addBlockTransformation(IBlockDefinition from, IBlockStateMatcher matcher, crafttweaker.api.block.IBlockState to) {
        Block f = CraftTweakerMC.getBlock((IBlockDefinition)from);
        IBlockState t = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)to);
        ItemTFTransformPowder.addBlockTransformation(f, (IBlockState state) -> matcher.matches(CraftTweakerMC.getBlockState((IBlockState)state)), t);
    }
}

