/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import twilightforest.TwilightForestMod;
import twilightforest.capabilities.CapabilityList;
import twilightforest.enums.BossVariant;

public interface IBossCapability
extends INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation ID = TwilightForestMod.prefix("cap_boss");

    public BossVariant getBossVariant();

    public BlockPos getHomePos();

    default public BlockPos getHomePos(EntityLivingBase entity) {
        BlockPos pos;
        BlockPos blockPos = pos = entity instanceof EntityCreature && this.getHomePos() == null ? ((EntityCreature)entity).func_180486_cf() : this.getHomePos();
        if (pos == null) {
            return entity.func_180425_c();
        }
        return pos;
    }

    default public boolean isBoss() {
        return this.getBossVariant() != null;
    }

    public void setBossVariant(BossVariant var1);

    public void setHomePos(BlockPos var1);

    public static void initBoss(EntityLivingBase entity, BossVariant variant) {
        IBossCapability boss = (IBossCapability)entity.getCapability(CapabilityList.BOSS, null);
        if (boss == null || boss.getBossVariant() != null) {
            return;
        }
        boss.setBossVariant(variant);
        boss.setHomePos(new BlockPos((Entity)entity));
    }
}

