/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.boss;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import twilightforest.capabilities.boss.IBossCapability;
import twilightforest.enums.BossVariant;

public class BossCapabilityHandler
implements IBossCapability,
INBTSerializable<NBTTagCompound> {
    private BossVariant variant = null;
    private BlockPos homePos = BlockPos.field_177992_a;

    @Override
    @Nullable
    public BossVariant getBossVariant() {
        return this.variant;
    }

    @Override
    @Nonnull
    public BlockPos getHomePos() {
        return this.homePos;
    }

    @Nonnull
    public final BlockPos getHomePos(Entity entity) {
        BlockPos position;
        BlockPos blockPos = position = entity instanceof EntityCreature && this.homePos == BlockPos.field_177992_a ? ((EntityCreature)entity).func_180486_cf() : this.homePos;
        if (position == null) {
            position = BlockPos.field_177992_a;
        }
        return position;
    }

    @Override
    public void setBossVariant(BossVariant variant) {
        this.variant = variant;
    }

    @Override
    public void setHomePos(@Nonnull BlockPos homePos) {
        this.homePos = homePos;
    }

    public void initBoss(BossVariant variant, BlockPos homePos) {
        this.variant = variant;
        this.homePos = homePos;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.variant != null) {
            tag.func_74768_a("variant", this.variant.ordinal());
        } else {
            tag.func_74768_a("variant", -1);
        }
        tag.func_74782_a("homePos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.homePos));
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        int id = tag.func_74762_e("variant");
        BossVariant variant = null;
        if (id > -1) {
            variant = BossVariant.getVariant(id);
        }
        this.initBoss(variant, NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("homePos")));
    }
}

