/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.TFBlocks;
import twilightforest.enums.MagicWoodVariant;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.item.TFItems;
import twilightforest.network.PacketChangeBiome;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;

public class BlockTFMagicLogSpecial
extends BlockTFMagicLog {
    protected BlockTFMagicLogSpecial() {
        this.func_149647_a(TFItems.creativeTab);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)TFBlocks.magic_log);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((MagicWoodVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || state.func_177229_b((IProperty)field_176299_a) != BlockLog.EnumAxis.NONE) {
            return;
        }
        switch ((MagicWoodVariant)((Object)state.func_177229_b(VARIANT))) {
            case TIME: {
                world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.1f, 0.5f);
                this.doTreeOfTimeEffect(world, pos, rand);
                break;
            }
            case TRANS: {
                world.func_184133_a(null, pos, SoundEvents.field_187682_dG, SoundCategory.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
                this.doTreeOfTransformationEffect(world, pos, rand);
                break;
            }
            case MINE: {
                this.doMinersTreeEffect(world, pos, rand);
                break;
            }
            case SORT: {
                this.doSortingTreeEffect(world, pos, rand);
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b((IProperty)field_176299_a) != BlockLog.EnumAxis.NONE) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        if (state.func_177229_b((IProperty)field_176299_a) == BlockLog.EnumAxis.NONE) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            return true;
        }
        return false;
    }

    private void doTreeOfTimeEffect(World world, BlockPos pos, Random rand) {
        int numticks = 24 * this.func_149738_a(world);
        for (int i = 0; i < numticks; ++i) {
            TileEntity te;
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, 16);
            IBlockState state = world.func_180495_p(dPos);
            Block block = state.func_177230_c();
            if (block != Blocks.field_150350_a && block.func_149653_t()) {
                block.func_180650_b(world, dPos, state, rand);
            }
            if (!((te = world.func_175625_s(dPos)) instanceof ITickable) || te.func_145837_r()) continue;
            ((ITickable)te).func_73660_a();
        }
    }

    private void doTreeOfTransformationEffect(World world, BlockPos pos, Random rand) {
        Biome targetBiome = TFBiomes.enchantedForest;
        for (int i = 0; i < 16; ++i) {
            Biome biomeAt;
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, 16, 0, 16);
            if (dPos.func_177951_i((Vec3i)pos) > 256.0 || (biomeAt = world.func_180494_b(dPos)) == targetBiome) continue;
            Chunk chunkAt = world.func_175726_f(dPos);
            chunkAt.func_76605_m()[(dPos.func_177952_p() & 0xF) << 4 | dPos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)targetBiome);
            if (!(world instanceof WorldServer)) break;
            this.sendChangedBiome(world, dPos, targetBiome);
            break;
        }
    }

    private void sendChangedBiome(World world, BlockPos pos, Biome biome) {
        PacketChangeBiome message = new PacketChangeBiome(pos, biome);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0);
        TFPacketHandler.CHANNEL.sendToAllTracking((IMessage)message, targetPoint);
    }

    private void doMinersTreeEffect(World world, BlockPos pos, Random rand) {
        BlockPos dPos = WorldUtil.randomOffset(rand, pos, 32);
        int moved = ItemTFOreMagnet.doMagnet(world, null, null, pos, dPos);
        if (moved > 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, BlockPos pos, Random rand) {
        block0: for (BlockPos iPos : WorldUtil.getAllAround(pos, 16)) {
            IItemHandler handler;
            TileEntity te;
            IBlockState state;
            Block block;
            Chunk chunk = world.func_175726_f(iPos);
            if (!chunk.func_177410_o() || !((block = (state = world.func_180495_p(iPos)).func_177230_c()) instanceof ITileEntityProvider) || (te = world.func_175625_s(iPos)) == null || (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null || handler.getSlots() == 1) continue;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b() || stack.func_190916_E() == stack.func_77976_d()) continue;
                stacks.add(stack);
            }
            if (stacks.isEmpty() || stacks.size() == 1) continue;
            boolean didAnything = false;
            for (int i1 = 0; i1 < stacks.size(); ++i1) {
                ItemStack stack1 = (ItemStack)stacks.get(i1);
                for (int i2 = 0; i2 < stacks.size(); ++i2) {
                    ItemStack stack2;
                    if (i1 == i2 || !this.areItemsStackable(stack1, stack2 = (ItemStack)stacks.get(i2))) continue;
                    didAnything = true;
                    int toInsert = Math.min(stack1.func_77976_d() - stack1.func_190916_E(), stack2.func_190916_E());
                    stack1.func_190917_f(toInsert);
                    stack2.func_190918_g(toInsert);
                }
                if (didAnything) continue block0;
            }
        }
    }

    private boolean areItemsStackable(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77985_e() || !stack2.func_77985_e()) {
            return false;
        }
        if (stack1.func_190916_E() == stack1.func_77976_d() || stack2.func_190916_E() == stack2.func_77976_d()) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && (!stack1.func_77942_o() && !stack2.func_77942_o() || stack1.func_77942_o() == stack2.func_77942_o() && Objects.requireNonNull(stack1.func_77978_p()).equals((Object)Objects.requireNonNull(stack2.func_77978_p())));
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return 15;
    }

    @Override
    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 3));
    }

    @Override
    protected boolean func_149700_E() {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }
}

