/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public abstract class NBTValueConverter {
    public static IValueType<? extends IValue> mapNBTToValueType(NBTBase nbt) {
        return NBTValueConverter.mapNBTIDToValueType(nbt.func_74732_a());
    }

    public static String getDefaultValueDisplayText(int nbtId) {
        String formatCode = NBTValueConverter.getDefaultValue(nbtId).getType().getDisplayColorFormat();
        switch (nbtId) {
            default: {
                return formatCode + "0";
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return formatCode + "[]";
            }
            case 8: {
                return formatCode + "\"\"";
            }
            case 10: 
        }
        return formatCode + "{}";
    }

    public static IValue getDefaultValue(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)0);
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)0L);
            }
            case 5: 
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)0.0);
            }
            case 7: 
            case 11: 
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, new ArrayList());
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)"");
            }
            case 9: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.CATEGORY_ANY, new ArrayList());
            }
        }
        return ValueTypeNbt.ValueNbt.of((NBTTagCompound)new NBTTagCompound());
    }

    public static IValueType<?> mapNBTIDToValueType(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypes.INTEGER;
            }
            case 4: {
                return ValueTypes.LONG;
            }
            case 5: 
            case 6: {
                return ValueTypes.DOUBLE;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return ValueTypes.LIST;
            }
            case 8: {
                return ValueTypes.STRING;
            }
            case 10: {
                return ValueTypes.NBT;
            }
        }
        throw new RuntimeException("Unexpected NBT id:" + nbtId);
    }

    public static IValue mapNBTToValue(NBTBase nbt) {
        switch (nbt.func_74732_a()) {
            case 1: {
                return ValueTypeInteger.ValueInteger.of((int)((NBTTagByte)nbt).func_150287_d());
            }
            case 2: {
                return ValueTypeInteger.ValueInteger.of((int)((NBTTagShort)nbt).func_150287_d());
            }
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)((NBTTagInt)nbt).func_150287_d());
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)((NBTTagLong)nbt).func_150291_c());
            }
            case 5: {
                return ValueTypeDouble.ValueDouble.of((double)((NBTTagFloat)nbt).func_150286_g());
            }
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)((NBTTagDouble)nbt).func_150286_g());
            }
            case 7: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((byte[])((NBTTagByteArray)nbt).func_150292_c())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)((NBTTagString)nbt).func_150285_a_());
            }
            case 9: {
                return ValueTypeList.ValueList.ofAll((IValue[])((IValue[])StreamSupport.stream(((NBTTagList)nbt).spliterator(), false).map(NBTValueConverter::mapNBTToValue).toArray(IValue[]::new)));
            }
            case 10: {
                return ValueTypeNbt.ValueNbt.of((NBTTagCompound)((NBTTagCompound)nbt));
            }
            case 11: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((int[])((NBTTagIntArray)nbt).func_150302_c())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.LONG, Arrays.stream(ArrayUtils.toObject((long[])((NBTTagLongArray)nbt).field_193587_b)).map(ValueTypeLong.ValueLong::of).collect(Collectors.toList()));
            }
        }
        return null;
    }
}

