/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import me.tepis.integratednbt.ExtendedGuiContainer;
import me.tepis.integratednbt.GlHelper;
import me.tepis.integratednbt.NBTExtractorGui;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import me.tepis.integratednbt.Wrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class NBTTreeViewer {
    private static final long SMOOTH_SCROLLING_TRANSITION_TIME_MS = 75L;
    private static final double SCROLL_SPEED = 0.25;
    private static final int LINE_SPACE = 1;
    private static final int EXPAND_BUTTON_RIGHT_MARGIN = 3;
    private static final int INDENTATION = 10;
    private static final int HIGHLIGHT_COLOR = 0x505050;
    private static final int SELECTED_COLOR = 5269584;
    private static final int LABEL_COLOR = 0xFFFF55;
    private static final int EXPAND_COLOR = 0xFFBB11;
    private static final int NUMBER_COLOR = 0x66FFFF;
    private static final int STRING_COLOR = 0x55FF55;
    private static final int COMPLEX_COLOR = 0xAAAAAA;
    private static final int EMPTY_COLOR = 0x777777;
    private static final int SCREEN_BACKGROUND_COLOR = 0x303030;
    private static final int SCROLL_BAR_COLOR = 0xCCCCCC;
    private static final int SCROLL_BAR_PADDING = 2;
    private static final int SCROLL_BAR_WIDTH = 3;
    private static final int EXPAND_BUTTON_SIZE = 7;
    private static final TexturePart PLUS_BUTTON = NBTExtractorGui.GUI_TEXTURE.createPart(48, 0, 7, 7);
    private static final TexturePart PLUS_BUTTON_HOVER = NBTExtractorGui.GUI_TEXTURE.createPart(48, 9, 7, 7);
    private static final TexturePart MINUS_BUTTON = NBTExtractorGui.GUI_TEXTURE.createPart(57, 0, 7, 7);
    private static final TexturePart MINUS_BUTTON_HOVER = NBTExtractorGui.GUI_TEXTURE.createPart(57, 9, 7, 7);
    private static final TexturePart PURE_COLOR = new Texture("integratednbt", "textures/gui/1x1.png").createPart(0, 0, 1, 1);
    private final Set<NBTPath> expandedPaths;
    private final Wrapper<Integer> scrollTop;
    private final FontRenderer fontRenderer;
    private ExtendedGuiContainer gui;
    private int left;
    private int top;
    private int width;
    private int height;
    private double renderScroll;
    private long renderScrollTransitionStartTime;
    private double renderScrollTransitionStartLocation;
    private int maxScroll;
    private int currentY;
    private int currentX;
    private NBTPath currentPath;
    private NBTPath hoveringPath;
    private NBTBase hoveringNBTNode;
    private NBTPath selecting;
    private int mouseX;
    private int mouseY;
    private NBTPath hoveringExpandableButton;

    public NBTTreeViewer(ExtendedGuiContainer gui, Set<NBTPath> expandedPaths, Wrapper<Integer> scrollTop) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.maxScroll = 0;
        this.gui = gui;
        this.expandedPaths = expandedPaths;
        this.scrollTop = scrollTop;
        this.renderScroll = scrollTop.get().intValue();
    }

    public void updateBounds(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public void handleMouseInput() {
        int dWheel = Mouse.getDWheel();
        int newValue = (int)((double)this.scrollTop.get().intValue() - (double)dWheel * 0.25);
        if (newValue < 0) {
            newValue = 0;
        } else if (newValue > this.maxScroll) {
            newValue = this.maxScroll;
        }
        if (this.scrollTop.get() != newValue) {
            this.scrollTop.set(newValue);
            this.startScrollTransition();
        }
    }

    private void startScrollTransition() {
        this.renderScrollTransitionStartLocation = this.renderScroll;
        this.renderScrollTransitionStartTime = System.currentTimeMillis();
    }

    private boolean renderKVPair(String label, String value, int valueColor) {
        boolean isThreeSideInBounds;
        if (label.isEmpty()) {
            return false;
        }
        boolean isSelected = this.getSelectedPath().equals(this.currentPath);
        boolean isHovering = false;
        int bottomBoundary = this.currentY + this.fontRenderer.field_78288_b;
        boolean bl = isThreeSideInBounds = this.mouseX >= 0 && this.mouseX < this.width && (double)this.mouseY >= this.renderScroll && (double)this.mouseY < this.renderScroll + (double)this.height && this.mouseY >= this.currentY && this.mouseY < bottomBoundary + 1 && this.mouseX >= this.currentX;
        if (isThreeSideInBounds || isSelected) {
            int rightBoundary = this.currentX + this.fontRenderer.func_78256_a(label + (value.isEmpty() ? "" : ": " + value));
            if (isSelected || this.mouseX < rightBoundary) {
                GlHelper.colorInt(isSelected ? 5269584 : 0x505050);
                if (isThreeSideInBounds && this.mouseX < rightBoundary) {
                    isHovering = true;
                }
                PURE_COLOR.renderTo(this.gui, this.currentX - 1, this.currentY - 1, rightBoundary - this.currentX + 1, bottomBoundary - this.currentY + 1);
            }
        }
        if (value.isEmpty()) {
            this.fontRenderer.func_78276_b(label, this.currentX, this.currentY, 0xFFFF55);
        } else {
            int valueX = this.fontRenderer.func_78276_b(label + ": ", this.currentX, this.currentY, 0xFFFF55);
            this.fontRenderer.func_78276_b(value, valueX, this.currentY, valueColor);
        }
        return isHovering;
    }

    private void renderExpandableButton(boolean expanded) {
        TexturePart part;
        boolean hovering;
        boolean bl = hovering = this.mouseX >= this.currentX && this.mouseX < this.currentX + 7 && this.mouseY >= this.currentY && this.mouseY < this.currentY + PLUS_BUTTON.getHeight();
        TexturePart texturePart = expanded ? (hovering ? MINUS_BUTTON_HOVER : MINUS_BUTTON) : (part = hovering ? PLUS_BUTTON_HOVER : PLUS_BUTTON);
        if (hovering) {
            this.hoveringExpandableButton = this.currentPath.copy();
        }
        GlHelper.colorInt(0xFFBB11);
        part.renderTo((Gui)this.gui, this.currentX, this.currentY);
        this.currentX += 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(NBTTagCompound nbt, int absMouseX, int absMouseY) {
        if (nbt == null) {
            return;
        }
        this.hoveringPath = null;
        this.hoveringNBTNode = null;
        this.hoveringExpandableButton = null;
        this.currentPath = new NBTPath();
        this.currentY = 4;
        this.updateScroll();
        this.mouseX = absMouseX - this.left;
        this.mouseY = (int)((double)(absMouseY - this.top) + this.renderScroll);
        GL11.glPushMatrix();
        try {
            GL11.glTranslated((double)this.left, (double)((double)this.top - this.renderScroll), (double)0.0);
            this.renderNode(I18n.func_135052_a((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]), (NBTBase)nbt);
            int totalHeight = this.currentY + 4;
            GL11.glTranslated((double)0.0, (double)this.renderScroll, (double)0.0);
            this.maxScroll = Math.max(totalHeight - this.height, 0);
            if (this.maxScroll != 0) {
                GlHelper.colorInt(0x303030);
                PURE_COLOR.renderTo(this.gui, this.width - 4 - 3, -1, 9, this.height);
                GlHelper.colorInt(0xCCCCCC);
                PURE_COLOR.renderTo(this.gui, this.width - 2 - 3, 2 + (int)(this.renderScroll / (double)totalHeight * (double)(this.height - 4)), 3, (int)Math.ceil((double)this.height / (double)totalHeight * (double)(this.height - 4)));
            }
            if (this.hoveringPath != null) {
                IValueType<? extends IValue> hoveringValueType = NBTValueConverter.mapNBTToValueType(this.hoveringNBTNode);
                ArrayList<String> list = new ArrayList<String>(5);
                list.add(this.hoveringPath.getDisplayText());
                list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.nbt_type", (Object[])new Object[]{NBTBase.func_193581_j((int)this.hoveringNBTNode.func_74732_a())}));
                list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.converted_type", (Object[])new Object[]{hoveringValueType.getDisplayColorFormat() + I18n.func_135052_a((String)hoveringValueType.getTranslationKey(), (Object[])new Object[0])}));
                list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.default_value", (Object[])new Object[]{NBTValueConverter.getDefaultValueDisplayText(this.hoveringNBTNode.func_74732_a())}));
                if (Objects.equals(this.getSelectedPath(), this.hoveringPath)) {
                    list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.selected", (Object[])new Object[0]));
                } else if (Objects.equals(this.selecting, this.hoveringPath)) {
                    list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.selecting", (Object[])new Object[0]));
                } else {
                    list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.left_click", (Object[])new Object[0]));
                }
                if (NBTTreeViewer.isNodeExpandable(this.hoveringNBTNode)) {
                    if (this.expandedPaths.contains(this.hoveringPath)) {
                        list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.right_click_collapse", (Object[])new Object[0]));
                    } else {
                        list.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip.right_click_expand", (Object[])new Object[0]));
                    }
                }
                GuiUtils.drawHoveringText(list, (int)this.mouseX, (int)((int)((double)this.mouseY - this.renderScroll)), (int)this.width, (int)this.height, (int)200, (FontRenderer)this.fontRenderer);
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private void updateScroll() {
        long transitionTime = System.currentTimeMillis() - this.renderScrollTransitionStartTime;
        if (transitionTime > 75L) {
            this.renderScroll = this.scrollTop.get().intValue();
            return;
        }
        double ratio = (double)transitionTime / 75.0;
        this.renderScroll = this.renderScrollTransitionStartLocation + ((double)this.scrollTop.get().intValue() - this.renderScrollTransitionStartLocation) * ratio;
    }

    public void mouseClicked(int mouseButton) {
        if (mouseButton == 0) {
            if (this.hoveringExpandableButton != null) {
                this.toggleExpanded(this.hoveringExpandableButton);
            }
            if (this.hoveringPath != null) {
                this.selecting = this.hoveringPath;
                this.onUpdateSelectedPath(this.hoveringPath, this.hoveringNBTNode);
            }
        } else if (mouseButton == 1 && this.hoveringPath != null && NBTTreeViewer.isNodeExpandable(this.hoveringNBTNode)) {
            this.toggleExpanded(this.hoveringPath);
        }
    }

    private void toggleExpanded(NBTPath path) {
        if (this.expandedPaths.contains(path)) {
            this.expandedPaths.remove(path);
        } else {
            this.expandedPaths.add(path.copy());
        }
    }

    public abstract void onUpdateSelectedPath(NBTPath var1, NBTBase var2);

    private static boolean isNodeExpandable(NBTBase nbt) {
        byte nbtId = nbt.func_74732_a();
        return nbtId == 9 || nbtId == 10;
    }

    private void renderEmpty() {
        this.currentX = (this.currentPath.getDepth() + 1) * 10 + 4 + 3 + 7;
        this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"integratednbt:nbt_extractor.empty", (Object[])new Object[0]), this.currentX, this.currentY, 0x777777);
        this.currentY += this.fontRenderer.field_78288_b + 1;
    }

    private void renderNode(String label, NBTBase node) {
        boolean isHoveringText;
        this.currentX = this.currentPath.getDepth() * 10 + 4;
        boolean isExpandedIfExpandable = false;
        if (NBTTreeViewer.isNodeExpandable(node)) {
            isExpandedIfExpandable = this.expandedPaths.contains(this.currentPath);
        } else {
            this.currentX += 10;
        }
        switch (node.func_74732_a()) {
            case 1: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagByte)node).func_150290_f()), 0x66FFFF);
                break;
            }
            case 2: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagShort)node).func_150289_e()), 0x66FFFF);
                break;
            }
            case 3: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagInt)node).func_150287_d()), 0x66FFFF);
                break;
            }
            case 4: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagLong)node).func_150291_c()), 0x66FFFF);
                break;
            }
            case 5: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagFloat)node).func_150288_h()), 0x66FFFF);
                break;
            }
            case 6: {
                isHoveringText = this.renderKVPair(label, String.valueOf(((NBTTagDouble)node).func_150286_g()), 0x66FFFF);
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                isHoveringText = this.renderKVPair(label, "[]", 0x66FFFF);
                break;
            }
            case 8: {
                isHoveringText = this.renderKVPair(label, '\"' + ((NBTTagString)node).func_150285_a_() + '\"', 0x55FF55);
                break;
            }
            case 9: 
            case 10: {
                this.renderExpandableButton(isExpandedIfExpandable);
                isHoveringText = this.renderKVPair(label, isExpandedIfExpandable ? "" : node.toString(), 0xAAAAAA);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected NBT id:" + node.func_74732_a());
            }
        }
        if (isHoveringText) {
            this.hoveringPath = this.currentPath.copy();
            this.hoveringNBTNode = node;
        }
        this.currentY += this.fontRenderer.field_78288_b + 1;
        if (isExpandedIfExpandable) {
            switch (node.func_74732_a()) {
                case 9: {
                    if (((NBTTagList)node).func_74745_c() == 0) {
                        this.renderEmpty();
                        break;
                    }
                    int i = 0;
                    for (NBTBase item : (NBTTagList)node) {
                        this.currentPath.pushIndex(i);
                        this.renderNode("#" + i, item);
                        this.currentPath.pop();
                        ++i;
                    }
                    break;
                }
                case 10: {
                    if (((NBTTagCompound)node).func_186856_d() == 0) {
                        this.renderEmpty();
                        break;
                    }
                    NBTTagCompound compound = (NBTTagCompound)node;
                    for (String key : compound.func_150296_c()) {
                        this.currentPath.pushKey(key);
                        this.renderNode(key, compound.func_74781_a(key));
                        this.currentPath.pop();
                    }
                    break;
                }
            }
        }
    }

    public abstract NBTPath getSelectedPath();
}

