/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Capabilities;
import me.tepis.integratednbt.Integration;
import me.tepis.integratednbt.NBTExtractedVariableFacade;
import me.tepis.integratednbt.NBTExtractedVariableFacadeHandler;
import me.tepis.integratednbt.NBTExtractionOperator;
import me.tepis.integratednbt.NBTExtractor;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorRemote;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import me.tepis.integratednbt.Wrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public class NBTExtractorTileEntity
extends TileEntity
implements ICapabilityProvider,
IInventory,
INetworkEventListener<NetworkElement>,
ITickable {
    public static final int SRC_NBT_SLOT = 0;
    public static final int VAR_OUT_SLOT = 1;
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private CableCapability cableCapability = new CableCapability();
    private NetworkCarrierDefault networkCarrierCapability = new NetworkCarrierDefault();
    private PathElementTile<NBTExtractorTileEntity> pathElementCapability = new PathElementTile((TileEntity)this, (ICable)this.cableCapability);
    private VariableContainerDefault variableContainerCapability = new VariableContainerDefault();
    private NetworkElementProviderSingleton networkElementProviderCapability = new NetworkElementProviderSingleton(){

        public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
            return new NetworkElement();
        }
    };
    private NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private InventoryVariableEvaluator<IValue> evaluator = new InventoryVariableEvaluator((IInventory)this, 0, (IValueType)ValueTypes.CATEGORY_ANY);
    private HashSet<NBTPath> expandedPaths;
    private Wrapper<Integer> scrollTop = new Wrapper<Integer>(0);
    private boolean shouldRefreshVariable = false;
    private boolean shouldUpdateOutVariable = false;
    private NBTPath extractionPath = new NBTPath();
    private byte defaultNBTId = 1;
    private NBTExtractorOutputMode outputMode = NBTExtractorOutputMode.REFERENCE;
    private NBTTagCompound lastEvaluatedNBT = null;
    private boolean autoRefresh = true;
    private NBTTagCompound frozenNBT = null;
    private ItemStack frozenNBTItemStack = ItemStack.field_190927_a;

    public NBTExtractorTileEntity() {
        this.expandedPaths = new HashSet();
        this.expandedPaths.add(new NBTPath());
    }

    public NBTExtractorOutputMode getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(NBTExtractorOutputMode outputMode) {
        this.outputMode = outputMode;
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables(true);
            this.shouldUpdateOutVariable = true;
            if (!this.autoRefresh && !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.func_70301_a(0), (ItemStack)this.frozenNBTItemStack)) {
                this.frozenNBTItemStack = this.func_70301_a(0);
                this.frozenNBT = null;
            }
        }
    }

    public void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.networkCarrierCapability.getNetwork(), sendVariablesUpdateEvent);
        this.variableContainerCapability.refreshVariables(this.networkCarrierCapability.getNetwork(), (IInventory)this, sendVariablesUpdateEvent);
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public void setDefaultNBTId(byte defaultNBTId) {
        this.defaultNBTId = defaultNBTId < 1 || defaultNBTId > 12 ? (byte)1 : defaultNBTId;
        this.func_70296_d();
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    public void setExtractionPath(NBTPath extractionPath) {
        this.extractionPath = extractionPath;
        this.func_70296_d();
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void updateAutoRefresh(boolean autoRefresh) {
        if (this.autoRefresh == autoRefresh) {
            return;
        }
        this.autoRefresh = autoRefresh;
        if (!autoRefresh) {
            this.frozenNBT = null;
            this.frozenNBTItemStack = ItemStack.field_190927_a;
        }
        this.func_70296_d();
    }

    public void updateLastEvaluatedNBT(NBTTagCompound lastEvaluatedNBT) {
        this.lastEvaluatedNBT = lastEvaluatedNBT;
        if (!this.autoRefresh && this.frozenNBT == null) {
            this.frozenNBT = this.lastEvaluatedNBT;
            this.frozenNBTItemStack = this.func_70301_a(0).func_77946_l();
        }
    }

    public HashSet<NBTPath> getExpandedPaths() {
        return this.expandedPaths;
    }

    public Wrapper<Integer> getScrollTop() {
        return this.scrollTop;
    }

    public IVariable<?> getSrcNBTVariable() {
        return this.evaluator.getVariable(NetworkHelpers.getPartNetwork((INetwork)this.networkCarrierCapability.getNetwork()));
    }

    public L10NHelpers.UnlocalizedString getFirstErrorMessage() {
        List errors = this.evaluator.getErrors();
        if (errors.isEmpty()) {
            return null;
        }
        return (L10NHelpers.UnlocalizedString)errors.get(0);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.CABLE_CAPABILITY || capability == Capabilities.NETWORK_CARRIER_CAPABILITY || capability == Capabilities.PATH_ELEMENT_CAPABILITY || capability == Capabilities.VARIABLE_CONTAINER_CAPABILITY || capability == Capabilities.NETWORK_ELEMENT_PROVIDER;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.CABLE_CAPABILITY) {
            return (T)this.cableCapability;
        }
        if (capability == Capabilities.NETWORK_CARRIER_CAPABILITY) {
            return (T)this.networkCarrierCapability;
        }
        if (capability == Capabilities.PATH_ELEMENT_CAPABILITY) {
            return (T)this.pathElementCapability;
        }
        if (capability == Capabilities.VARIABLE_CONTAINER_CAPABILITY) {
            return (T)this.variableContainerCapability;
        }
        if (capability == Capabilities.NETWORK_ELEMENT_PROVIDER) {
            return (T)this.networkElementProviderCapability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.itemStacks.size();
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        if (player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0) {
            return true;
        }
        return this.isRemote(player.func_184614_ca()) || this.isRemote(player.func_184592_cb());
    }

    private boolean isRemote(ItemStack itemStack) {
        if (itemStack.func_77973_b() != NBTExtractorRemote.getInstance()) {
            return false;
        }
        NBTTagCompound tag = NBTExtractorRemote.getInstance().getModNBT(itemStack);
        return tag.func_74764_b("world") && tag.func_74762_e("world") == this.field_145850_b.field_73011_w.getDimension() && tag.func_74762_e("x") == this.field_174879_c.func_177958_n() && tag.func_74762_e("y") == this.field_174879_c.func_177956_o() && tag.func_74762_e("z") == this.field_174879_c.func_177952_p();
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return Integration.isVariable(stack);
    }

    public NBTTagCompound getFrozenValue() {
        if (this.autoRefresh) {
            return null;
        }
        return this.frozenNBT;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    @Nonnull
    public String func_70005_c_() {
        return "tile.integratednbt:nbt_extractor.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasEventSubscriptions() {
        return true;
    }

    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Collections.singleton(VariableContentsUpdatedEvent.class);
    }

    public void onEvent(INetworkEvent event, NetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables(false);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldRefreshVariable = true;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldRefreshVariable && this.networkCarrierCapability.getNetwork() != null) {
                this.shouldRefreshVariable = false;
                this.refreshVariables(true);
            }
            if (this.shouldUpdateOutVariable) {
                this.updateOutVariable();
            }
        }
    }

    private void updateOutVariable() {
        if (!((ItemStack)this.itemStacks.get(1)).func_190926_b()) {
            ItemStack result = null;
            switch (this.outputMode) {
                case REFERENCE: {
                    result = this.getVariableByReferenceMode();
                    break;
                }
                case OPERATOR: {
                    result = this.getVariableByOperatorMode();
                    break;
                }
                case VALUE: {
                    result = this.getVariableByValueMode();
                }
            }
            if (result != null) {
                this.itemStacks.set(1, (Object)result);
            }
        }
    }

    @Nullable
    private ItemStack getVariableByReferenceMode() {
        this.refreshVariables(true);
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariableFacade variableFacade = this.evaluator.getVariableFacade();
        if (variableFacade != null) {
            final int sourceNBTId = variableFacade.getId();
            IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade> factory = new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade>(){

                public NBTExtractedVariableFacade create(boolean generateId) {
                    return new NBTExtractedVariableFacade(generateId, sourceNBTId, NBTExtractorTileEntity.this.extractionPath, NBTExtractorTileEntity.this.defaultNBTId);
                }

                public NBTExtractedVariableFacade create(int id) {
                    return new NBTExtractedVariableFacade(id, sourceNBTId, NBTExtractorTileEntity.this.extractionPath, NBTExtractorTileEntity.this.defaultNBTId);
                }
            };
            return registry.writeVariableFacadeItem(true, (ItemStack)this.itemStacks.get(1), (IVariableFacadeHandler)NBTExtractedVariableFacadeHandler.getInstance(), (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)factory, null, this.func_145838_q());
        }
        return null;
    }

    @Nullable
    private ItemStack getVariableByOperatorMode() {
        return this.getVariableUsingValue((IValue)ValueTypeOperator.ValueOperator.of((IOperator)new NBTExtractionOperator(this.extractionPath, this.defaultNBTId)));
    }

    @Nullable
    private ItemStack getVariableByValueMode() {
        this.refreshVariables(true);
        NBTBase extractedNBT = this.extractionPath.extract((NBTBase)(!this.autoRefresh && this.frozenNBT != null ? this.frozenNBT : this.lastEvaluatedNBT));
        IValue value = extractedNBT == null ? NBTValueConverter.getDefaultValue(this.defaultNBTId) : NBTValueConverter.mapNBTToValue(extractedNBT);
        return this.getVariableUsingValue(value);
    }

    @Nullable
    private ItemStack getVariableUsingValue(final IValue value) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        if (value == null) {
            return null;
        }
        return registry.writeVariableFacadeItem(true, (ItemStack)this.itemStacks.get(1), (IVariableFacadeHandler)ValueTypes.REGISTRY, (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

            public IValueTypeVariableFacade create(boolean generateId) {
                return new ValueTypeVariableFacade(generateId, value.getType(), value);
            }

            public IValueTypeVariableFacade create(int id) {
                return new ValueTypeVariableFacade(id, value.getType(), value);
            }
        }, null, this.func_145838_q());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagList errorsList = new NBTTagList();
        for (L10NHelpers.UnlocalizedString error : this.evaluator.getErrors()) {
            errorsList.func_74742_a((NBTBase)error.toNBT());
        }
        tag.func_74782_a("errors", (NBTBase)errorsList);
        tag.func_74782_a("path", (NBTBase)this.extractionPath.toNBT());
        tag.func_74774_a("defaultNBTId", this.defaultNBTId);
        tag.func_74774_a("outputMode", (byte)this.outputMode.ordinal());
        tag.func_74757_a("isAutoRefresh", this.autoRefresh);
        if (!this.autoRefresh) {
            if (this.frozenNBT != null) {
                tag.func_74782_a("frozenNBT", (NBTBase)this.frozenNBT);
            }
            tag.func_74782_a("frozenNBTItemStack", (NBTBase)this.frozenNBTItemStack.func_77955_b(new NBTTagCompound()));
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.itemStacks);
        return super.func_189515_b(tag);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        ITextComponent superDisplayName = super.func_145748_c_();
        return superDisplayName == null ? new TextComponentString("") : superDisplayName;
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("errors")) {
            NBTTagList errorsList = tag.func_150295_c("errors", 10);
            this.evaluator.setErrors(StreamSupport.stream(errorsList.spliterator(), false).map(nbtBase -> {
                L10NHelpers.UnlocalizedString string = new L10NHelpers.UnlocalizedString();
                string.fromNBT((NBTTagCompound)nbtBase);
                return string;
            }).collect(Collectors.toList()));
        }
        if (tag.func_74764_b("path")) {
            this.extractionPath = NBTPath.fromNBT(tag.func_74781_a("path")).orElse(new NBTPath());
        }
        if (tag.func_74764_b("defaultNBTId")) {
            this.defaultNBTId = tag.func_74771_c("defaultNBTId");
        }
        if (tag.func_74764_b("outputMode")) {
            this.outputMode = NBTExtractorOutputMode.values()[tag.func_74771_c("outputMode")];
        }
        if (tag.func_74764_b("isAutoRefresh")) {
            this.autoRefresh = tag.func_74767_n("isAutoRefresh");
            if (!this.autoRefresh) {
                if (tag.func_74764_b("frozenNBT")) {
                    this.frozenNBT = tag.func_74775_l("frozenNBT");
                }
                this.frozenNBTItemStack = new ItemStack(tag.func_74775_l("frozenNBTItemStack"));
            }
        }
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.itemStacks);
        this.shouldRefreshVariable = true;
        super.func_145839_a(tag);
    }

    public void afterNetworkReAlive() {
        this.shouldRefreshVariable = true;
        this.connected.clear();
    }

    class NetworkElement
    implements IEventListenableNetworkElement<NBTExtractorTileEntity> {
        NetworkElement() {
        }

        public int getUpdateInterval() {
            return 0;
        }

        public boolean isUpdate() {
            return false;
        }

        public void update(INetwork network) {
        }

        public void beforeNetworkKill(INetwork network) {
        }

        public void afterNetworkAlive(INetwork network) {
        }

        public void afterNetworkReAlive(INetwork network) {
            NBTExtractorTileEntity.this.afterNetworkReAlive();
        }

        public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        }

        public boolean onNetworkAddition(INetwork network) {
            return Objects.requireNonNull(NetworkHelpers.getPartNetwork((INetwork)network)).addVariableContainer(DimPos.of((World)NBTExtractorTileEntity.this.field_145850_b, (BlockPos)NBTExtractorTileEntity.this.field_174879_c));
        }

        public void onNetworkRemoval(INetwork network) {
            Objects.requireNonNull(NetworkHelpers.getPartNetwork((INetwork)network)).removeVariableContainer(DimPos.of((World)NBTExtractorTileEntity.this.field_145850_b, (BlockPos)NBTExtractorTileEntity.this.field_174879_c));
        }

        public void onPreRemoved(INetwork network) {
        }

        public void onPostRemoved(INetwork network) {
        }

        public void onNeighborBlockChange(@Nullable INetwork network, IBlockAccess world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        }

        public void setPriorityAndChannel(INetwork network, int priority, int channel) {
        }

        public int getPriority() {
            return 0;
        }

        public int getChannel() {
            return 0;
        }

        public void invalidate(INetwork network) {
            network.invalidateElement((INetworkElement)this);
        }

        public boolean canRevalidate(INetwork network) {
            return NBTExtractorTileEntity.this.field_145850_b.func_175667_e(NBTExtractorTileEntity.this.func_174877_v());
        }

        public void revalidate(INetwork network) {
            network.revalidateElement((INetworkElement)this);
        }

        public int compareTo(INetworkElement o) {
            return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
        }

        @Nullable
        public NBTExtractorTileEntity getNetworkEventListener() {
            return NBTExtractorTileEntity.this;
        }
    }

    class CableCapability
    implements ICable {
        CableCapability() {
        }

        public boolean canConnect(ICable connector, EnumFacing side) {
            return true;
        }

        public boolean isConnected(EnumFacing side) {
            if (NBTExtractorTileEntity.this.connected.isEmpty()) {
                this.updateConnections();
            }
            return (Boolean)NBTExtractorTileEntity.this.connected.get((Object)side);
        }

        public void updateConnections() {
            NBTExtractorTileEntity entity = NBTExtractorTileEntity.this;
            World world = entity.func_145831_w();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                boolean cableConnected = CableHelpers.canCableConnectTo((IBlockAccess)world, (BlockPos)entity.func_174877_v(), (EnumFacing)side, (ICable)this);
                entity.connected.put((Enum)side, (Object)cableConnected);
            }
            entity.func_145831_w().func_175646_b(entity.func_174877_v(), (TileEntity)entity);
            IBlockState blockState = world.func_180495_p(NBTExtractorTileEntity.this.field_174879_c);
            world.func_184138_a(NBTExtractorTileEntity.this.field_174879_c, blockState, blockState, 3);
        }

        public void disconnect(EnumFacing side) {
        }

        public void reconnect(EnumFacing side) {
        }

        public ItemStack getItemStack() {
            return new ItemStack(NBTExtractor.getInstance().getItemBlock());
        }

        public void destroy() {
        }
    }
}

