/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.IntegratedNBT;
import me.tepis.integratednbt.IntegratedNBTCreativeTab;
import me.tepis.integratednbt.NBTExtractor;
import me.tepis.integratednbt.network.serverbound.NBTExtractorRemoteRequestMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NBTExtractorRemote
extends Item {
    public static final String REGISTRY_NAME = "integratednbt:nbt_extractor_remote";
    private static NBTExtractorRemote instance;

    public NBTExtractorRemote() {
        this.setRegistryName(REGISTRY_NAME);
        this.func_77655_b(REGISTRY_NAME);
        this.func_77637_a(IntegratedNBTCreativeTab.getInstance());
        this.func_77625_d(1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (world.field_72995_K) {
            this.clientUse(player.func_184586_b(hand), player);
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUse(ItemStack itemStack, EntityPlayer player) {
        NBTTagCompound nbt = this.getModNBT(itemStack);
        if (!nbt.func_74764_b("world")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.need_bind", new Object[0]));
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() != nbt.func_74762_e("world")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.require_dim", new Object[0]));
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        if (!world.func_175668_a(pos, false)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.require_load_client", new Object[0]));
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() != NBTExtractor.getInstance()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.invalid_bind", new Object[0]));
            return;
        }
        IntegratedNBT.getNetworkChannel().sendToServer((IMessage)new NBTExtractorRemoteRequestMessage());
    }

    public NBTTagCompound getModNBT(ItemStack itemStack) {
        return itemStack.func_190925_c("integratednbt");
    }

    public void serverUse(ItemStack itemStack, EntityPlayerMP player) {
        BlockPos pos;
        NBTTagCompound nbt = this.getModNBT(itemStack);
        if (!nbt.func_74764_b("world")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.need_bind", new Object[0]));
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("world"));
        if (!world.func_175667_e(pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")))) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.require_load_server", new Object[0]));
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() != NBTExtractor.getInstance()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.invalid_bind", new Object[0]));
            return;
        }
        NBTExtractor.getInstance().playerAccess((World)world, pos, player);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.func_180495_p(pos).func_177230_c() == NBTExtractor.getInstance()) {
            if (!world.field_72995_K) {
                NBTExtractorRemote.getInstance().bindBlock(player.func_184586_b(hand), world, pos);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("integratednbt:nbt_extractor_remote.bind_successful", new Object[]{String.valueOf(pos.func_177958_n()), String.valueOf(pos.func_177956_o()), String.valueOf(pos.func_177952_p())}));
            }
        } else if (world.field_72995_K) {
            this.clientUse(player.func_184586_b(hand), player);
        }
        return EnumActionResult.SUCCESS;
    }

    public void bindBlock(ItemStack itemStack, World world, BlockPos pos) {
        NBTTagCompound nbt = this.getModNBT(itemStack);
        nbt.func_74768_a("world", world.field_73011_w.getDimension());
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
    }

    public static NBTExtractorRemote getInstance() {
        if (instance == null) {
            instance = new NBTExtractorRemote();
        }
        return instance;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        NBTTagCompound nbt = this.getModNBT(itemStack);
        if (nbt.func_74764_b("world")) {
            tooltip.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor_remote.tooltip.bound", (Object[])new Object[]{String.valueOf(nbt.func_74762_e("x")), String.valueOf(nbt.func_74762_e("y")), String.valueOf(nbt.func_74762_e("z")), String.valueOf(nbt.func_74762_e("world"))}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor_remote.tooltip.not_bound", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor_remote.tooltip", (Object[])new Object[0]));
    }
}

