/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import me.tepis.integratednbt.ExtendedGuiContainer;
import me.tepis.integratednbt.HoverTextImageButton;
import me.tepis.integratednbt.IntegratedNBT;
import me.tepis.integratednbt.NBTExtractorContainer;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTTreeViewer;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import me.tepis.integratednbt.network.clientbound.NBTExtractorUpdateClientMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateAutoRefreshMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateExtractionPathMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateOutputModeMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class NBTExtractorGui
extends ExtendedGuiContainer {
    public static final int SCREEN_EDGE = 4;
    public static final Texture GUI_TEXTURE = new Texture("integratednbt", "textures/gui/nbt_extractor.png");
    private static final TexturePart PART0 = GUI_TEXTURE.createPart(0, 0, 8, 24);
    private static final TexturePart PART1 = GUI_TEXTURE.createPart(12, 0, 4, 24);
    private static final TexturePart PART2 = GUI_TEXTURE.createPart(20, 0, 8, 24);
    private static final TexturePart PART3 = GUI_TEXTURE.createPart(0, 28, 8, 4);
    private static final TexturePart PART4 = GUI_TEXTURE.createPart(12, 28, 4, 4);
    private static final TexturePart PART5 = GUI_TEXTURE.createPart(20, 28, 8, 4);
    private static final TexturePart PART6 = GUI_TEXTURE.createPart(0, 36, 8, 8);
    private static final TexturePart PART7 = GUI_TEXTURE.createPart(12, 36, 4, 8);
    private static final TexturePart PART8 = GUI_TEXTURE.createPart(20, 36, 178, 110);
    private static final TexturePart PART9 = GUI_TEXTURE.createPart(202, 36, 8, 8);
    private static final int BUTTON_SIZE = 12;
    private static final TexturePart BUTTON_UNKNOWN = GUI_TEXTURE.createPart(78, 0, 12, 12);
    private static final TexturePart BUTTON_UNKNOWN_HOVER = GUI_TEXTURE.createPart(78, 12, 12, 12);
    private static final TexturePart BUTTON_REFERENCE_MODE = GUI_TEXTURE.createPart(90, 0, 12, 12);
    private static final TexturePart BUTTON_REFERENCE_MODE_HOVER = GUI_TEXTURE.createPart(90, 12, 12, 12);
    private static final TexturePart BUTTON_OPERATOR_MODE = GUI_TEXTURE.createPart(102, 0, 12, 12);
    private static final TexturePart BUTTON_OPERATOR_MODE_HOVER = GUI_TEXTURE.createPart(102, 12, 12, 12);
    private static final TexturePart BUTTON_VALUE_MODE = GUI_TEXTURE.createPart(114, 0, 12, 12);
    private static final TexturePart BUTTON_VALUE_MODE_HOVER = GUI_TEXTURE.createPart(114, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON = GUI_TEXTURE.createPart(126, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON_HOVER = GUI_TEXTURE.createPart(126, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF = GUI_TEXTURE.createPart(138, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF_HOVER = GUI_TEXTURE.createPart(138, 12, 12, 12);
    private static final int BASE_PADDING = 200;
    private static final int INVENTORY_WIDTH = 178;
    private static final int INVENTORY_HEIGHT = 110;
    private static final int TOP_BORDER_SIZE = 24;
    private static final int SIDE_BORDER_SIZE = 8;
    private static final double CENTERED_TEXT_MAX_RATIO = 0.8;
    private static final int BUTTON_SPACING = 2;
    private static NBTExtractorGui lastInstance = null;
    private static NBTExtractorUpdateClientMessage.ErrorCode errorCode = null;
    private static NBTTagCompound nbt;
    private static NBTPath extractionPath;
    private static NBTExtractorOutputMode outputMode;
    private static L10NHelpers.UnlocalizedString errorMessage;
    private static Boolean autoRefresh;
    private NBTTreeViewer treeViewer;
    private NBTExtractorContainer nbtExtractorContainer;
    private int padding;
    private int screenWidth;
    private int screenHeight;
    private int scaleFactor;
    private HoverTextImageButton outputModeButton;
    private HoverTextImageButton autoRefreshButton;

    public NBTExtractorGui(final NBTExtractorContainer nbtExtractorContainer) {
        super(nbtExtractorContainer);
        lastInstance = this;
        this.nbtExtractorContainer = nbtExtractorContainer;
        NBTExtractorTileEntity tileEntity = nbtExtractorContainer.getNbtExtractorEntity();
        this.treeViewer = new NBTTreeViewer(this, tileEntity.getExpandedPaths(), tileEntity.getScrollTop()){

            @Override
            public void onUpdateSelectedPath(NBTPath newPath, NBTBase nbt) {
                IntegratedNBT.getNetworkChannel().sendToServer((IMessage)new NBTExtractorUpdateExtractionPathMessage(nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), newPath, nbt.func_74732_a()));
            }

            @Override
            public NBTPath getSelectedPath() {
                return extractionPath;
            }
        };
    }

    public static void updateError(NBTExtractorUpdateClientMessage.ErrorCode errorCode) {
        NBTExtractorGui.errorCode = errorCode;
    }

    public static void updateNBT(NBTTagCompound nbt) {
        NBTExtractorGui.nbt = nbt;
    }

    public static void updateExtractionPath(NBTPath extractionPath) {
        NBTExtractorGui.extractionPath = extractionPath;
    }

    public static void updateOutputMode(NBTExtractorOutputMode outputMode) {
        NBTExtractorGui.outputMode = outputMode;
        if (lastInstance != null) {
            lastInstance.updateOutputModeButton();
        }
    }

    private void updateOutputModeButton() {
        if (this.outputModeButton == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (outputMode == null) {
            this.outputModeButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0])}));
        } else if (outputMode == NBTExtractorOutputMode.REFERENCE) {
            this.outputModeButton.setTexture(BUTTON_REFERENCE_MODE, BUTTON_REFERENCE_MODE_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode.reference", (Object[])new Object[0])}));
        } else if (outputMode == NBTExtractorOutputMode.OPERATOR) {
            this.outputModeButton.setTexture(BUTTON_OPERATOR_MODE, BUTTON_OPERATOR_MODE_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode.operator", (Object[])new Object[0])}));
        } else {
            this.outputModeButton.setTexture(BUTTON_VALUE_MODE, BUTTON_VALUE_MODE_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode.value", (Object[])new Object[0])}));
        }
        messages.addAll(Arrays.asList(I18n.func_135052_a((String)"integratednbt:nbt_extractor.output_mode.description", (Object[])new Object[0]).split("\\\\n")));
        this.outputModeButton.setHoverText(messages);
    }

    public static void updateErrorMessage(L10NHelpers.UnlocalizedString errorMessage) {
        NBTExtractorGui.errorMessage = errorMessage;
    }

    public static void updateAutoRefresh(Boolean autoRefresh) {
        NBTExtractorGui.autoRefresh = autoRefresh;
        if (lastInstance != null) {
            lastInstance.updateAutoRefreshButton();
        }
    }

    public void func_146281_b() {
        lastInstance = null;
        errorCode = null;
        nbt = null;
        extractionPath = null;
        outputMode = null;
        errorMessage = null;
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.treeViewer.mouseClicked(mouseButton);
    }

    public void func_73866_w_() {
        this.updateCalculations();
        this.field_146999_f = this.field_146294_l - 2 * this.padding;
        this.field_147000_g = this.field_146295_m - 2 * this.padding;
        super.func_73866_w_();
        this.nbtExtractorContainer.setSlotOffset((this.field_146999_f - 178) / 2, this.field_147000_g - 110);
        this.treeViewer.updateBounds(this.padding + 8, this.padding + 24, this.screenWidth, this.screenHeight);
        this.outputModeButton = new HoverTextImageButton((GuiScreen)this, 0, this.field_146294_l - this.padding - 7 - 12, this.padding + 7);
        this.updateOutputModeButton();
        this.func_189646_b(this.outputModeButton);
        this.autoRefreshButton = new HoverTextImageButton((GuiScreen)this, 1, this.field_146294_l - this.padding - 7 - 24 - 2, this.padding + 7);
        this.updateAutoRefreshButton();
        this.func_189646_b(this.autoRefreshButton);
    }

    private void updateCalculations() {
        this.scaleFactor = new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        this.padding = (int)Math.min(Math.max(200.0 / Math.pow(this.scaleFactor, 3.0), 4.0), (double)Math.min(this.field_146294_l, this.field_146295_m) / 10.0);
        this.screenWidth = this.field_146294_l - 2 * this.padding - 16;
        this.screenHeight = this.field_146295_m - 2 * this.padding - 24 - 110;
    }

    private void updateAutoRefreshButton() {
        if (this.autoRefreshButton == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (autoRefresh == null) {
            this.autoRefreshButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0])}));
        } else if (autoRefresh.booleanValue()) {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_ON, BUTTON_REFRESH_ON_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.on", (Object[])new Object[0])}));
        } else {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_OFF, BUTTON_REFRESH_OFF_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.off", (Object[])new Object[0])}));
        }
        messages.addAll(Arrays.asList(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.description", (Object[])new Object[0]).split("\\\\n")));
        this.autoRefreshButton.setHoverText(messages);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (errorCode == NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR && nbt != null) {
            this.treeViewer.handleMouseInput();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.outputModeButton.drawHover(mouseX, mouseY);
        this.autoRefreshButton.drawHover(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderGuiParts();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.integratednbt:nbt_extractor.name", (Object[])new Object[0]), this.padding + 8, this.padding + 9, 0x404040);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.scaleFactor * (this.padding + 8)), (int)(this.scaleFactor * (this.padding + 110)), (int)(this.scaleFactor * this.screenWidth), (int)(this.scaleFactor * this.screenHeight));
        Slot srcNBTSlot = this.nbtExtractorContainer.getSrcNBTSlot();
        if (!srcNBTSlot.func_75216_d()) {
            errorCode = null;
            this.renderWelcome();
        } else if (errorCode == null) {
            this.renderLoading();
        } else if (!errorCode.equals((Object)NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR)) {
            this.renderError();
        } else {
            this.treeViewer.render(nbt, mouseX, mouseY);
        }
        GL11.glDisable((int)3089);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.outputModeButton) {
            if (outputMode == null) {
                return;
            }
            IntegratedNBT.getNetworkChannel().sendToServer((IMessage)new NBTExtractorUpdateOutputModeMessage(this.nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), NBTExtractorOutputMode.values()[(outputMode.ordinal() + 1) % NBTExtractorOutputMode.values().length]));
        } else if (button == this.autoRefreshButton) {
            if (autoRefresh == null) {
                return;
            }
            IntegratedNBT.getNetworkChannel().sendToServer((IMessage)new NBTExtractorUpdateAutoRefreshMessage(this.nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), autoRefresh == false));
        }
    }

    private void renderGuiParts() {
        int padding = this.padding;
        int screenWidth = this.screenWidth;
        int screenHeight = this.screenHeight;
        GUI_TEXTURE.bind();
        PART0.renderTo((Gui)this, padding, padding);
        PART1.renderTo(this, padding + 8, padding, screenWidth, -1);
        PART2.renderTo((Gui)this, this.field_146294_l - padding - 8, padding);
        PART3.renderTo(this, padding, padding + 24, -1, screenHeight);
        PART4.renderTo(this, padding + 8, padding + 24, screenWidth, screenHeight);
        PART5.renderTo(this, this.field_146294_l - padding - 8, padding + 24, -1, screenHeight);
        int topOfPart6789 = this.field_146295_m - padding - 110;
        PART6.renderTo((Gui)this, padding, topOfPart6789);
        int part7Width2x = this.field_146294_l - 2 * padding - 16 - 178;
        int part7WidthFloor = (int)Math.floor((double)part7Width2x / 2.0);
        int part7WidthCeil = (int)Math.ceil((double)part7Width2x / 2.0);
        PART7.renderTo(this, padding + 8, topOfPart6789, part7WidthFloor, -1);
        PART8.renderTo((Gui)this, padding + 8 + part7WidthFloor, topOfPart6789);
        PART7.renderTo(this, padding + 8 + part7WidthFloor + 178, topOfPart6789, part7WidthCeil, -1);
        PART9.renderTo((Gui)this, this.field_146294_l - padding - 8, topOfPart6789);
    }

    private void renderWelcome() {
        this.renderCenteredTextGroup(I18n.func_135052_a((String)"integratednbt:nbt_extractor.welcome", (Object[])new Object[0]), 65535, I18n.func_135052_a((String)"integratednbt:nbt_extractor.welcome.description", (Object[])new Object[0]));
    }

    private void renderLoading() {
        this.renderCenteredTextGroup(I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0]), 0xFFFF00, I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading.description", (Object[])new Object[0]));
    }

    private void renderError() {
        String message = "";
        if (errorMessage != null) {
            message = errorMessage.localize();
        } else {
            switch (errorCode) {
                case EVAL_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.eval", (Object[])new Object[0]);
                    break;
                }
                case TYPE_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.type", (Object[])new Object[0]);
                    break;
                }
                case UNEXPECTED_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.unexpected", (Object[])new Object[0]);
                }
            }
        }
        this.renderCenteredTextGroup(I18n.func_135052_a((String)"integratednbt:nbt_extractor.error", (Object[])new Object[0]), 0xFF5555, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCenteredTextGroup(String title, int titleColor, String description) {
        GL11.glPushMatrix();
        try {
            int x = this.screenCenterX();
            int y = this.screenCenterY();
            int titleWidth = this.field_146289_q.func_78256_a(title);
            GL11.glPushMatrix();
            try {
                this.scaleAt(x, y, 2.0);
                this.field_146289_q.func_78276_b(title, -titleWidth / 2, -this.field_146289_q.field_78288_b - 1, titleColor);
            }
            finally {
                GL11.glPopMatrix();
            }
            this.scaleAt(x, y, 1.0);
            int wrappingWidth = (int)((double)this.screenWidth * 0.8);
            int descriptionWidth = this.field_146289_q.func_78256_a(description);
            if (descriptionWidth > wrappingWidth) {
                this.field_146289_q.func_78279_b(description, -wrappingWidth / 2, 4, wrappingWidth, 0xFFFFFF);
            } else {
                this.field_146289_q.func_78276_b(description, -descriptionWidth / 2, 4, 0xFFFFFF);
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private int screenCenterX() {
        return this.field_146294_l / 2;
    }

    private int screenCenterY() {
        return this.padding + 24 + this.screenHeight / 2;
    }

    private void scaleAt(int x, int y, double scale) {
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        GL11.glTranslated((double)((double)x / scale), (double)((double)y / scale), (double)0.0);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        extractionPath = null;
        outputMode = null;
        errorMessage = null;
        autoRefresh = null;
    }
}

