/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Objects;
import javax.annotation.Nonnull;
import me.tepis.integratednbt.IntegratedNBT;
import me.tepis.integratednbt.Integration;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.network.clientbound.NBTExtractorUpdateClientMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;

public class NBTExtractorContainer
extends Container {
    private static final int SRC_NBT = 0;
    private static final int VAR_OUT = 1;
    private static final int INVENTORY_START = 2;
    private static final int INVENTORY_END = 38;
    private InventoryPlayer playerInventory;
    private NBTExtractorTileEntity nbtExtractorEntity;
    private NBTExtractorUpdateClientMessage.ErrorCode clientErrorCode = null;
    private NBTTagCompound clientNBT = null;
    private NBTPath clientPath = null;
    private NBTExtractorOutputMode clientOutputMode = null;
    private L10NHelpers.UnlocalizedString clientErrorMessage = null;
    private Boolean clientAutoRefresh = null;

    public NBTExtractorContainer(InventoryPlayer playerInventory, NBTExtractorTileEntity nbtExtractorEntity) {
        int i;
        this.playerInventory = playerInventory;
        this.nbtExtractorEntity = nbtExtractorEntity;
        this.func_75146_a(new SrcNBTSlot(nbtExtractorEntity, 0, 9, 6));
        this.func_75146_a(new VarOutSlot(nbtExtractorEntity, 1, 153, 6));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new ResponsiveSlot((IInventory)playerInventory, j + i * 9 + 9, 9 + j * 18, 28 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new ResponsiveSlot((IInventory)playerInventory, i, 9 + i * 18, 86));
        }
    }

    public NBTExtractorTileEntity getNbtExtractorEntity() {
        return this.nbtExtractorEntity;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.nbtExtractorEntity.func_145831_w().field_72995_K) {
            NBTExtractorOutputMode outputMode;
            NBTPath nbtPath;
            NBTExtractorUpdateClientMessage.ErrorCode errorCode;
            NBTTagCompound nbt = this.clientNBT;
            L10NHelpers.UnlocalizedString errorMessage = null;
            if (!this.func_75139_a(0).func_75216_d()) {
                this.clientErrorCode = null;
                errorCode = null;
            } else {
                try {
                    NBTTagCompound frozenValue = this.nbtExtractorEntity.getFrozenValue();
                    if (frozenValue == null) {
                        IVariable<?> variable = this.nbtExtractorEntity.getSrcNBTVariable();
                        if (variable == null) {
                            errorCode = NBTExtractorUpdateClientMessage.ErrorCode.EVAL_ERROR;
                            errorMessage = this.nbtExtractorEntity.getFirstErrorMessage();
                        } else {
                            IValue value = variable.getValue();
                            if (value instanceof ValueTypeNbt.ValueNbt) {
                                nbt = ((ValueTypeNbt.ValueNbt)value).getRawValue();
                                errorCode = NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR;
                            } else {
                                errorCode = NBTExtractorUpdateClientMessage.ErrorCode.TYPE_ERROR;
                            }
                        }
                    } else {
                        errorCode = NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR;
                        nbt = frozenValue;
                    }
                }
                catch (PartStateException | EvaluationException exception) {
                    exception.printStackTrace();
                    errorCode = NBTExtractorUpdateClientMessage.ErrorCode.EVAL_ERROR;
                    errorMessage = new L10NHelpers.UnlocalizedString(exception.getMessage(), new Object[0]);
                }
                catch (Exception exception) {
                    errorCode = NBTExtractorUpdateClientMessage.ErrorCode.UNEXPECTED_ERROR;
                    IntegratedNBT.getLogger().error("Unexpected error occurred while evaluating variable.", (Throwable)exception);
                }
            }
            NBTExtractorUpdateClientMessage message = new NBTExtractorUpdateClientMessage();
            if (!Objects.equals(this.clientNBT, nbt)) {
                message.updateNBT(nbt);
                this.clientNBT = nbt;
            }
            if (this.clientErrorCode != errorCode) {
                message.updateErrorCode(errorCode);
                this.clientErrorCode = errorCode;
            }
            if (this.clientPath != (nbtPath = this.nbtExtractorEntity.getExtractionPath())) {
                message.updateExtractionPath(nbtPath);
                this.clientPath = nbtPath;
            }
            if (this.clientOutputMode != (outputMode = this.nbtExtractorEntity.getOutputMode())) {
                message.updateOutputMode(outputMode);
                this.clientOutputMode = outputMode;
            }
            if (!Objects.equals(errorMessage, this.clientErrorMessage)) {
                message.updateErrorMessage(errorMessage);
                this.clientErrorMessage = errorMessage;
            }
            if (this.clientAutoRefresh == null || this.nbtExtractorEntity.isAutoRefresh() != this.clientAutoRefresh.booleanValue()) {
                message.updateAutoRefresh(this.nbtExtractorEntity.isAutoRefresh());
                this.clientAutoRefresh = this.nbtExtractorEntity.isAutoRefresh();
            }
            if (!message.isEmpty()) {
                EntityPlayerMP playerMP = (EntityPlayerMP)this.playerInventory.field_70458_d;
                IntegratedNBT.getNetworkChannel().sendTo((IMessage)message, playerMP);
            }
            if (errorCode == NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR) {
                this.nbtExtractorEntity.updateLastEvaluatedNBT(nbt);
            } else {
                this.nbtExtractorEntity.updateLastEvaluatedNBT(null);
            }
        }
    }

    public void setSlotOffset(int x, int y) {
        for (Slot slot : this.field_75151_b) {
            ((ResponsiveSlot)slot).setOffset(x, y);
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    @Nonnull
    public Slot getSrcNBTSlot() {
        return this.func_75139_a(0);
    }

    @Nonnull
    public Slot getVarOutSlot() {
        return this.func_75139_a(1);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack leftOver = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack fromSlot = slot.func_75211_c();
            leftOver = fromSlot.func_77946_l();
            if (index == 0 || index == 1) {
                if (!this.func_75135_a(fromSlot, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (Integration.isVariable(fromSlot)) {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d()) {
                    if (((Slot)this.field_75151_b.get(1)).func_75216_d()) {
                        return ItemStack.field_190927_a;
                    }
                    Slot varOutSlot = this.func_75139_a(1);
                    varOutSlot.func_75215_d(fromSlot.func_77979_a(1));
                    varOutSlot.func_75218_e();
                } else {
                    Slot srcNBTSlot = this.func_75139_a(0);
                    srcNBTSlot.func_75215_d(fromSlot.func_77979_a(1));
                    srcNBTSlot.func_75218_e();
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (fromSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (fromSlot.func_190916_E() == leftOver.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, fromSlot);
        }
        return leftOver;
    }

    private static class SrcNBTSlot
    extends VariableSlot {
        public SrcNBTSlot(IInventory inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }
    }

    private static class VarOutSlot
    extends VariableSlot {
        public VarOutSlot(IInventory inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }
    }

    private static class VariableSlot
    extends ResponsiveSlot {
        public VariableSlot(IInventory inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
        }

        public boolean func_75214_a(ItemStack stack) {
            return Integration.isVariable(stack);
        }

        public int func_178170_b(ItemStack stack) {
            return 1;
        }
    }

    private static class ResponsiveSlot
    extends Slot {
        private int baseX;
        private int baseY;

        public ResponsiveSlot(IInventory inventoryIn, int index, int baseX, int baseY) {
            super(inventoryIn, index, baseX, baseY);
            this.baseX = baseX;
            this.baseY = baseY;
        }

        public void setOffset(int xPos, int yPos) {
            this.field_75223_e = this.baseX + xPos;
            this.field_75221_f = this.baseY + yPos;
        }
    }
}

