/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.CabledBlock;
import me.tepis.integratednbt.Capabilities;
import me.tepis.integratednbt.IntegratedNBT;
import me.tepis.integratednbt.IntegratedNBTCreativeTab;
import me.tepis.integratednbt.NBTExtractorRemote;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.commoncapabilities.api.capability.wrench.IWrench;
import org.cyclops.commoncapabilities.api.capability.wrench.WrenchTarget;

public class NBTExtractor
extends CabledBlock {
    public static final String REGISTRY_NAME = "integratednbt:nbt_extractor";
    public static final String TRANSLATION_KEY = "tile.integratednbt:nbt_extractor.name";
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static NBTExtractor instance;
    private Item itemBlock = new NBTExtractorItem();

    private NBTExtractor() {
        super(Material.field_151574_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(IntegratedNBTCreativeTab.getInstance());
        this.setRegistryName(REGISTRY_NAME);
        this.func_149663_c(REGISTRY_NAME);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public static NBTExtractor getInstance() {
        if (instance == null) {
            instance = new NBTExtractor();
        }
        return instance;
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState state) {
        TileEntity tileentity = world.func_175625_s(blockPos);
        if (tileentity instanceof NBTExtractorTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)((NBTExtractorTileEntity)tileentity));
        }
        super.func_180663_b(world, blockPos, state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new NBTExtractorTileEntity();
    }

    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        super.func_180633_a(world, pos, state, placer, itemStack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (heldItem.hasCapability(Capabilities.WRENCH_CAPABILITY, null) && ((IWrench)Objects.requireNonNull(heldItem.getCapability(org.cyclops.integrateddynamics.Capabilities.WRENCH, null))).canUse(player, WrenchTarget.forBlock((World)world, (BlockPos)pos, (EnumFacing)side)) && player.func_70093_af()) {
                this.destroyBlock(world, pos, true);
                return true;
            }
            if (heldItem.func_77973_b() == NBTExtractorRemote.getInstance()) {
                return false;
            }
            if (!player.func_70093_af()) {
                this.playerAccess(world, pos, playerMP);
            }
        }
        return true;
    }

    public void playerAccess(World world, BlockPos pos, EntityPlayerMP playerMP) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof NBTExtractorTileEntity) {
            NBTExtractorTileEntity nbtExtractorTileEntity = (NBTExtractorTileEntity)tileentity;
            nbtExtractorTileEntity.refreshVariables(true);
            playerMP.openGui((Object)IntegratedNBT.getInstance(), 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private class NBTExtractorItem
    extends ItemBlock {
        public NBTExtractorItem() {
            super((Block)NBTExtractor.this);
            this.setRegistryName(NBTExtractor.REGISTRY_NAME);
        }

        public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
            super.func_77624_a(itemStack, world, tooltip, flag);
            tooltip.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.tooltip", (Object[])new Object[0]));
        }
    }
}

