/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import net.minecraft.nbt.NBTBase;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class NBTExtractionOperator
implements IOperator {
    private NBTPath extractionPath;
    private byte defaultNBTId;

    public NBTExtractionOperator(NBTPath extractionPath, byte defaultNBTId) {
        this.extractionPath = extractionPath;
        this.defaultNBTId = defaultNBTId;
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    public byte getDefaultNBTId() {
        return this.defaultNBTId;
    }

    public String getUniqueName() {
        return "integratednbt:nbt_extraction";
    }

    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)"integratednbt:nbt_extraction_operator.full_name", (Object[])new Object[0]);
    }

    public void loadTooltip(List<String> lines, boolean appendOptionalInfo) {
        String operatorName = L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0]);
        String categoryName = L10NHelpers.localize((String)this.getUnlocalizedCategoryName(), (Object[])new Object[0]);
        String symbol = this.getSymbol();
        String outputTypeName = L10NHelpers.localize((String)this.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.operator_name", (Object[])new Object[]{operatorName, symbol}));
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.operator_category", (Object[])new Object[]{categoryName}));
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.input_type_name", (Object[])new Object[]{1, ValueTypes.NBT.getDisplayColorFormat() + L10NHelpers.localize((String)ValueTypes.NBT.getTranslationKey(), (Object[])new Object[0])}));
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.output_type_name", (Object[])new Object[]{this.getOutputType().getDisplayColorFormat() + outputTypeName}));
    }

    public String getTranslationKey() {
        return "integratednbt:nbt_extraction_operator.name";
    }

    public String getUnlocalizedCategoryName() {
        return "integratednbt:nbt_extraction_operator.category_name";
    }

    public String getSymbol() {
        return this.extractionPath.getCompactDisplayText();
    }

    public IValueType<?> getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    public IValueType<?>[] getInputTypes() {
        return new IValueType[]{ValueTypes.NBT};
    }

    public IValueType<?> getConditionalOutputType(IVariable[] input) {
        try {
            NBTBase extracted;
            IValue value;
            if (input.length == 1 && (value = input[0].getValue()) instanceof ValueTypeNbt.ValueNbt && (extracted = this.extractionPath.extract((NBTBase)((ValueTypeNbt.ValueNbt)value).getRawValue())) != null) {
                return NBTValueConverter.mapNBTToValueType(extracted);
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        return NBTValueConverter.mapNBTIDToValueType(this.defaultNBTId);
    }

    public IValue evaluate(IVariable ... input) throws EvaluationException {
        NBTBase extracted;
        IValue value;
        if (input.length == 1 && (value = input[0].getValue()) instanceof ValueTypeNbt.ValueNbt && (extracted = this.extractionPath.extract((NBTBase)((ValueTypeNbt.ValueNbt)value).getRawValue())) != null) {
            return NBTValueConverter.mapNBTToValue(extracted);
        }
        return NBTValueConverter.getDefaultValue(this.defaultNBTId);
    }

    public int getRequiredInputLength() {
        return 1;
    }

    public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
        if (input.length != 1) {
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_input_length", new Object[]{new L10NHelpers.UnlocalizedString("integratednbt:nbt_extraction_operator.full_name", new Object[0]), input.length, 1});
        }
        IValueType inputType = input[0];
        if (inputType == null) {
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.null_type", new Object[]{new L10NHelpers.UnlocalizedString("integratednbt:nbt_extraction_operator.full_name", new Object[0]), "0"});
        }
        if (!ValueHelpers.correspondsTo((IValueType)ValueTypes.NBT, (IValueType)inputType)) {
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_type", new Object[]{new L10NHelpers.UnlocalizedString("integratednbt:nbt_extraction_operator.full_name", new Object[0]), new L10NHelpers.UnlocalizedString(inputType.getTranslationKey(), new Object[0]), "1", new L10NHelpers.UnlocalizedString(ValueTypes.NBT.getTranslationKey(), new Object[0])});
        }
        return null;
    }

    public IConfigRenderPattern getRenderPattern() {
        return null;
    }

    public IOperator materialize() {
        return this;
    }
}

