/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Optional;
import me.tepis.integratednbt.NBTExtractedVariableFacade;
import me.tepis.integratednbt.NBTPath;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;

public class NBTExtractedVariableFacadeHandler
implements IVariableFacadeHandler<NBTExtractedVariableFacade> {
    private static final String VARIABLE_TYPE_ID = "integratednbt:nbt_extracted";
    private static final String KEY_SOURCE_NBT_ID = "sourceNBTId";
    private static final String KEY_EXTRACTION_PATH = "extractionPath";
    private static final String KEY_DEFAULT_NBT_ID = "defaultNBTId";
    private static NBTExtractedVariableFacadeHandler instance;

    public static NBTExtractedVariableFacadeHandler getInstance() {
        if (instance == null) {
            instance = new NBTExtractedVariableFacadeHandler();
        }
        return instance;
    }

    public String getTypeId() {
        return VARIABLE_TYPE_ID;
    }

    public NBTExtractedVariableFacade getVariableFacade(int id, NBTTagCompound tag) {
        int sourceNBTId = tag.func_74762_e(KEY_SOURCE_NBT_ID);
        Optional<NBTPath> extractionPath = NBTPath.fromNBT(tag.func_74781_a(KEY_EXTRACTION_PATH));
        byte defaultNBTId = tag.func_74771_c(KEY_DEFAULT_NBT_ID);
        return new NBTExtractedVariableFacade(id, sourceNBTId, (NBTPath)extractionPath.orElse(null), defaultNBTId);
    }

    public void setVariableFacade(NBTTagCompound tag, NBTExtractedVariableFacade facade) {
        tag.func_74768_a(KEY_SOURCE_NBT_ID, facade.getSourceNBTId());
        tag.func_74782_a(KEY_EXTRACTION_PATH, (NBTBase)facade.getExtractionPath().toNBT());
        tag.func_74774_a(KEY_DEFAULT_NBT_ID, facade.getDefaultNBTId());
    }
}

