/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nullable;
import me.tepis.integratednbt.NBTExtractedVariable;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class NBTExtractedVariableFacade
extends VariableFacadeBase {
    private int sourceNBTId;
    private NBTPath extractionPath;
    private byte defaultNBTId;
    private boolean validating;
    private boolean gettingVariable;
    private int lastNetworkHash;
    private NBTExtractedVariable variable;

    public NBTExtractedVariableFacade(boolean generateId, int sourceNBTId, @Nullable NBTPath extractionPath, byte defaultNBTId) {
        super(generateId);
        this.sourceNBTId = sourceNBTId;
        this.extractionPath = extractionPath;
        this.defaultNBTId = defaultNBTId;
    }

    public NBTExtractedVariableFacade(int id, int sourceNBTId, @Nullable NBTPath extractionPath, byte defaultNBTId) {
        super(id);
        this.sourceNBTId = sourceNBTId;
        this.extractionPath = extractionPath;
        this.defaultNBTId = defaultNBTId;
    }

    public byte getDefaultNBTId() {
        return this.defaultNBTId;
    }

    public int getSourceNBTId() {
        return this.sourceNBTId;
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, World world) {
        if (!this.isValid()) {
            return;
        }
        list.add(I18n.func_135052_a((String)"integratednbt:nbt_extracted_variable.tooltip.source_nbt_id", (Object[])new Object[]{this.sourceNBTId}));
        list.add(I18n.func_135052_a((String)"integratednbt:nbt_extracted_variable.tooltip.path", (Object[])new Object[]{this.extractionPath.getDisplayText()}));
        list.add(I18n.func_135052_a((String)"integratednbt:nbt_extracted_variable.tooltip.default_value", (Object[])new Object[]{NBTValueConverter.getDefaultValueDisplayText(this.defaultNBTId)}));
        super.addInformation(list, world);
    }

    public boolean isValid() {
        return this.extractionPath != null;
    }

    public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
        int newNetworkHash;
        if (!this.isValid()) {
            return null;
        }
        int n = newNetworkHash = network != null ? network.hashCode() : -1;
        if (this.variable == null || newNetworkHash != this.lastNetworkHash) {
            this.lastNetworkHash = newNetworkHash;
            if (network == null || !network.hasVariableFacade(this.sourceNBTId)) {
                return null;
            }
            IVariableFacade sourceNbtVariableFacade = network.getVariableFacade(this.sourceNBTId);
            if (!sourceNbtVariableFacade.isValid() || sourceNbtVariableFacade == this) {
                return null;
            }
            if (this.gettingVariable) {
                return null;
            }
            this.gettingVariable = true;
            IVariable sourceNbtVariable = sourceNbtVariableFacade.getVariable(network);
            this.gettingVariable = false;
            if (sourceNbtVariable == null) {
                return null;
            }
            this.variable = new NBTExtractedVariable((IVariable<ValueTypeNbt.ValueNbt>)sourceNbtVariable, this.extractionPath, this.defaultNBTId);
        }
        return this.variable;
    }

    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            return;
        }
        if (this.sourceNBTId < 0) {
            validator.addError(new L10NHelpers.UnlocalizedString("variable.integrateddynamics.error.invalid_item", new Object[0]));
        } else if (!network.hasVariableFacade(this.sourceNBTId)) {
            validator.addError(new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.variable_not_in_network", new Object[]{Integer.toString(this.sourceNBTId)}));
        } else {
            IVariableFacade sourceVariableFacade = network.getVariableFacade(this.sourceNBTId);
            if (sourceVariableFacade == this) {
                validator.addError(new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.cyclic_reference", new Object[]{Integer.toString(this.sourceNBTId)}));
            } else if (sourceVariableFacade != null) {
                Wrapper isValid = new Wrapper((Object)true);
                if (this.validating) {
                    validator.addError(new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.cyclic_reference", new Object[]{this.getId()}));
                }
                this.validating = true;
                sourceVariableFacade.validate(network, error -> {
                    validator.addError(error);
                    isValid.set((Object)false);
                }, (IValueType)ValueTypes.NBT);
                this.validating = false;
            }
        }
    }

    public IValueType<?> getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads) {
    }
}

