/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public abstract class CabledBlock
extends Block {
    public CabledBlock(Material materialIn) {
        super(materialIn);
    }

    public void destroyBlock(World world, BlockPos pos, boolean dropBlock) {
        this.onPreBlockDestroyed(world, pos);
        world.func_175655_b(pos, dropBlock);
        this.onPostBlockDestroyed(world, pos);
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos) {
        CableHelpers.onCableRemoving((World)world, (BlockPos)pos, (boolean)true, (boolean)false);
    }

    protected void onPostBlockDestroyed(World world, BlockPos pos) {
        CableHelpers.onCableRemoved((World)world, (BlockPos)pos, (Collection)CableHelpers.getExternallyConnectedCables((World)world, (BlockPos)pos));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            CableHelpers.onCableAdded((World)world, (BlockPos)pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        if (!world.field_72995_K) {
            CableHelpers.onCableAddedByPlayer((World)world, (BlockPos)pos, (EntityLivingBase)placer);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState blockState, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.onPreBlockDestroyed(world, pos);
        return super.removedByPlayer(blockState, world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, @Nonnull BlockPos blockPos, @Nonnull Explosion explosion) {
        this.onPreBlockDestroyed(world, blockPos);
        super.onBlockExploded(world, blockPos, explosion);
        this.onPostBlockDestroyed(world, blockPos);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState state) {
        this.onPreBlockDestroyed(world, blockPos);
        super.func_180663_b(world, blockPos, state);
        this.onPostBlockDestroyed(world, blockPos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        NetworkHelpers.onElementProviderBlockNeighborChange((World)world, (BlockPos)pos, (Block)neighborBlock, null, (BlockPos)fromPos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World) {
            NetworkHelpers.onElementProviderBlockNeighborChange((World)((World)world), (BlockPos)pos, (Block)world.func_180495_p(neighbor).func_177230_c(), null, (BlockPos)neighbor);
        }
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        NetworkHelpers.onElementProviderBlockNeighborChange((World)world, (BlockPos)observerPos, (Block)changedBlock, null, (BlockPos)changedBlockPos);
    }
}

