/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.storage;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SeedStorageSlot {
    private AgriSeed seed;
    public int count;
    private int slotId;
    private int invId;

    public SeedStorageSlot(AgriSeed seed, int count, int slotId, int invId) {
        this.seed = seed;
        this.count = count;
        this.slotId = slotId;
        this.invId = invId;
    }

    public ItemStack toStack() {
        return this.seed.toStack(this.count);
    }

    public AgriSeed getSeed() {
        return this.seed;
    }

    private int getTotalStat() {
        return this.seed.getStat().getGrowth() + this.seed.getStat().getGain() + this.seed.getStat().getStrength();
    }

    public int getId() {
        return this.invId >= 0 ? 1000 * this.invId + this.slotId : this.slotId;
    }

    public void writeToNbt(NBTTagCompound tag) {
        this.seed.toStack().func_77955_b(tag);
        tag.func_74768_a("agri_count", this.count);
        tag.func_74768_a("agri_id", this.slotId);
    }

    public static final Optional<SeedStorageSlot> readFromNbt(NBTTagCompound tag, int invId) {
        Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(new ItemStack(tag));
        if (seed.isPresent()) {
            int id = tag.func_74762_e("agri_id");
            int count = tag.func_74762_e("agri_count");
            count = count < 0 ? 0 : count;
            return Optional.of(new SeedStorageSlot(seed.get(), count, id, invId));
        }
        return Optional.empty();
    }

    public static class SlotComparator
    implements Comparator<SeedStorageSlot> {
        private final String stat;

        public SlotComparator(String stat) {
            this.stat = stat;
        }

        @Override
        public int compare(SeedStorageSlot o1, SeedStorageSlot o2) {
            IAgriStat s1 = o1.getSeed().getStat();
            IAgriStat s2 = o2.getSeed().getStat();
            int[] a1 = new int[]{s1.getGain(), s1.getGrowth(), s1.getStrength()};
            int[] a2 = new int[]{s2.getGain(), s2.getGrowth(), s2.getStrength()};
            for (int i = 0; i < 3; ++i) {
                if (a1[i] < a2[i]) {
                    return -1;
                }
                if (a1[i] <= a2[i]) continue;
                return 1;
            }
            return 0;
        }
    }
}

