/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.infinitylib.block.tile.TileEntityRotatableBase;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCustomWood
extends TileEntityRotatableBase
implements IDebuggable,
IAgriDisplayable {
    @Nonnull
    private CustomWoodType woodType = CustomWoodTypeRegistry.DEFAULT;

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getIcon() {
        return this.woodType.getIcon();
    }

    protected final void writeRotatableTileNBT(NBTTagCompound tag) {
        this.woodType.writeToNBT(tag);
        this.writeNBT(tag);
    }

    protected void writeNBT(NBTTagCompound tag) {
    }

    protected final void readRotatableTileNBT(NBTTagCompound tag) {
        this.setMaterial(CustomWoodTypeRegistry.getFromNbt(tag).orElse(CustomWoodTypeRegistry.DEFAULT));
        this.readNBT(tag);
    }

    protected void readNBT(NBTTagCompound tag) {
    }

    public final boolean isSameMaterial(TileEntityCustomWood tileEntity) {
        return tileEntity != null && this.func_145832_p() == tileEntity.func_145832_p() && this.getMaterialBlock() == tileEntity.getMaterialBlock() && this.getMaterialMeta() == tileEntity.getMaterialMeta();
    }

    public final void setMaterial(@Nonnull CustomWoodType type) {
        this.woodType = Objects.requireNonNull(type, "The wood type of a custom wood block may not be null!");
    }

    public final void setMaterial(ItemStack stack) {
        this.setMaterial(CustomWoodTypeRegistry.getFromNbt(stack.func_77978_p()).orElse(CustomWoodTypeRegistry.DEFAULT));
    }

    public final void setMaterial(Block block, int meta) {
        if (block != null) {
            this.setMaterial(CustomWoodTypeRegistry.getFromBlockAndMeta(block, meta).orElse(CustomWoodTypeRegistry.DEFAULT));
        }
    }

    public final CustomWoodType getMaterial() {
        return this.woodType;
    }

    public final Block getMaterialBlock() {
        return this.getMaterial().getBlock();
    }

    public final IBlockState getMaterialState() {
        return this.getMaterial().getState();
    }

    public final int getMaterialMeta() {
        return this.getMaterial().getMeta();
    }

    public final ItemStack getMaterialStack() {
        return this.getMaterial().getStack();
    }

    public final NBTTagCompound getMaterialTag() {
        return this.getMaterial().writeToNBT(new NBTTagCompound());
    }

    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("Material: " + this.getMaterialBlock().getRegistryName() + ":" + this.getMaterialMeta());
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        Preconditions.checkNotNull(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.material") + ": " + this.getMaterialStack().func_82833_r());
    }
}

