/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.storage.BlockSeedStorage;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockCustomWood;
import com.infinityraider.agricraft.tiles.storage.TileEntitySeedStorage;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSeedStorage
extends RenderBlockCustomWood<BlockSeedStorage, TileEntitySeedStorage> {
    public RenderSeedStorage(BlockSeedStorage block) {
        super(block, new TileEntitySeedStorage(), true, true, true);
    }

    private void renderSides(ITessellator tessellator, TextureAtlasSprite matIcon) {
        tessellator.drawScaledPrism(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f, matIcon);
        tessellator.drawScaledPrism(0.0f, 15.0f, 0.0f, 16.0f, 16.0f, 16.0f, matIcon);
        tessellator.drawScaledPrism(0.0f, 1.0f, 0.0f, 1.0f, 15.0f, 16.0f, matIcon);
        tessellator.drawScaledPrism(15.0f, 1.0f, 0.0f, 16.0f, 15.0f, 16.0f, matIcon);
        tessellator.drawScaledPrism(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f, matIcon);
        tessellator.drawScaledPrism(1.1f, 1.1f, 1.0f, 14.9f, 14.9f, 2.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 3.0f, 0.0f, 5.0f, 10.0f, 1.0f, matIcon);
        tessellator.drawScaledPrism(11.0f, 3.0f, 0.0f, 12.0f, 10.0f, 1.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 10.0f, 0.0f, 12.0f, 11.0f, 1.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 3.0f, 0.0f, 12.0f, 4.0f, 1.0f, matIcon);
        tessellator.drawScaledPrism(7.0f, 12.0f, 0.0f, 9.0f, 13.0f, 1.0f, BaseIcons.IRON_BLOCK.getIcon());
        tessellator.drawScaledFace(1.0f, 1.0f, 1.5f, 15.0f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(14.5f, 1.0f, 15.0f, 15.0f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(1.0f, 14.5f, 15.0f, 15.0f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(1.0f, 1.0f, 15.0f, 1.5f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(3.5f, 2.5f, 5.5f, 11.5f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(10.5f, 2.5f, 12.5f, 11.5f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(3.5f, 2.5f, 12.5f, 4.5f, EnumFacing.NORTH, matIcon, 0.99f);
        tessellator.drawScaledFace(3.5f, 9.5f, 12.5f, 11.5f, EnumFacing.NORTH, matIcon, 0.99f);
    }

    private void drawSeed(ITessellator tess, ItemStack seed) {
        if (seed.func_190926_b() || seed.func_77973_b() == null) {
            return;
        }
        float dx = 0.5f;
        float dy = 0.3125f;
        float dz = 0.061875f;
        float f = 0.75f;
        VertexFormat format = tess.getVertexFormat();
        tess.draw();
        RenderSeedStorage.renderItemStack((ItemStack)seed, (double)dx, (double)dy, (double)dz, (double)f, (boolean)false);
        tess.startDrawingQuads(format);
        tess.pushMatrix();
    }

    @Override
    protected void renderWorldBlockWoodDynamic(ITessellator tess, World world, BlockPos pos, BlockSeedStorage block, TileEntitySeedStorage tile, TextureAtlasSprite icon) {
        tess.pushMatrix();
        RenderSeedStorage.rotateBlock((ITessellator)tess, (EnumFacing)tile.getOrientation().func_176734_d());
        tile.getLockedSeed().ifPresent(s -> this.drawSeed(tess, s.toStack()));
        tess.popMatrix();
    }

    @Override
    protected void renderWorldBlockWoodStatic(ITessellator tess, IExtendedBlockState state, BlockSeedStorage block, EnumFacing side, TextureAtlasSprite icon) {
        tess.pushMatrix();
        RenderSeedStorage.rotateBlock((ITessellator)tess, (EnumFacing)((EnumFacing)AgriProperties.FACING.getValue((IBlockState)state)));
        this.renderSides(tess, icon);
        tess.popMatrix();
    }

    @Override
    protected void renderInventoryBlockWood(ITessellator tess, World world, IBlockState state, BlockSeedStorage block, TileEntitySeedStorage tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite icon) {
        this.renderSides(tess, icon);
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

