/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers;

import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class PlantRenderer {
    public static void renderPlant(@Nonnull ITessellator tessellator, @Nonnull IAgriPlant plant, int growthStage) {
        TextureAtlasSprite iconA = tessellator.getIcon(plant.getPrimaryPlantTexture(growthStage));
        TextureAtlasSprite iconB = tessellator.getIcon(plant.getSecondaryPlantTexture(growthStage));
        if (iconA == null) {
            iconB = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        if (iconB == null) {
            iconB = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        if (iconA != null) {
            switch (plant.getRenderMethod()) {
                case CROSSED: {
                    PlantRenderer.renderCrossPattern(tessellator, iconA, 0);
                    break;
                }
                case HASHTAG: {
                    PlantRenderer.renderHashTagPattern(tessellator, iconA, 0);
                    break;
                }
                case STEM: {
                    PlantRenderer.renderStemPlant(tessellator, iconA, iconB, growthStage);
                    break;
                }
                case TALL_CROSSED: {
                    PlantRenderer.renderCrossPattern(tessellator, iconA, 0);
                    if (iconB == null) break;
                    PlantRenderer.renderCrossPattern(tessellator, iconA, 1);
                    break;
                }
                case TALL_HASHTAG: {
                    PlantRenderer.renderHashTagPattern(tessellator, iconA, 0);
                    if (iconB == null) break;
                    PlantRenderer.renderHashTagPattern(tessellator, iconA, 1);
                }
            }
        }
    }

    private static void renderHashTagPattern(ITessellator tessellator, TextureAtlasSprite icon, int layer) {
        int minY = 16 * layer;
        int maxY = 16 * (layer + 1);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.NORTH, icon, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.EAST, icon, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.NORTH, icon, 12.0f);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.EAST, icon, 12.0f);
    }

    private static void renderCrossPattern(ITessellator tessellator, TextureAtlasSprite icon, int layer) {
        int minY = 16 * layer;
        int maxY = 16 * (layer + 1);
        tessellator.pushMatrix();
        tessellator.translate(0.5f, 0.0f, 0.5f);
        tessellator.rotate(45.0f, 0.0f, 1.0f, 0.0f);
        tessellator.translate(-0.5f, 0.0f, -0.5f);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.NORTH, icon, 8.0f);
        tessellator.drawScaledFaceDouble(0.0f, (float)minY, 16.0f, (float)maxY, EnumFacing.EAST, icon, 8.0f);
        tessellator.popMatrix();
    }

    private static void renderStemPlant(ITessellator tessellator, TextureAtlasSprite vineIcon, TextureAtlasSprite fruitIcon, int stage) {
        int translation = stage >= 6 ? 0 : 5 - stage;
        tessellator.pushMatrix();
        tessellator.translate(0.0f, -0.125f * (float)translation, 0.0f);
        if (stage >= 7) {
            PlantRenderer.renderStemPattern(tessellator, vineIcon);
            tessellator.drawScaledPrism(7.0f, 0.0f, 2.0f, 11.0f, 4.0f, 6.0f, fruitIcon);
            tessellator.drawScaledPrism(10.0f, 0.0f, 7.0f, 14.0f, 4.0f, 11.0f, fruitIcon);
            tessellator.drawScaledPrism(5.0f, 0.0f, 10.0f, 9.0f, 4.0f, 14.0f, fruitIcon);
            tessellator.drawScaledPrism(2.0f, 0.0f, 5.0f, 6.0f, 4.0f, 9.0f, fruitIcon);
        } else {
            PlantRenderer.renderCrossPattern(tessellator, vineIcon, 0);
        }
        tessellator.popMatrix();
    }

    private static void renderStemPattern(ITessellator tessellator, TextureAtlasSprite icon) {
        boolean minY = false;
        int maxY = 12;
        tessellator.drawScaledFaceDouble(-2.0f, (float)minY, 10.0f, (float)maxY, EnumFacing.NORTH, icon, 4.0f);
        tessellator.drawScaledFaceDouble(6.0f, (float)minY, 18.0f, (float)maxY, EnumFacing.EAST, icon, 4.0f);
        tessellator.drawScaledFaceDouble(6.0f, (float)minY, 18.0f, (float)maxY, EnumFacing.NORTH, icon, 12.0f);
        tessellator.drawScaledFaceDouble(-2.0f, (float)minY, 10.0f, (float)maxY, EnumFacing.EAST, icon, 12.0f);
    }
}

