/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemTrowel
extends ItemBase
implements IAgriTrowelItem,
IItemWithModel {
    @AgriConfigurable(category=AgriConfigCategory.TOOLS, key="Enable Trowel", comment="Set to false to disable the Trowel.")
    public static boolean enableTrowel = true;
    @AgriConfigurable(category=AgriConfigCategory.TOOLS, key="Trowel Debuff", min="0", max="1000", comment="The number of growth stages a plant loses when moved with the trowel.")
    public static int trowelDebuff = 1;

    public ItemTrowel() {
        super("trowel");
        this.field_77777_bU = 1;
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public boolean func_82788_x() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitx, float hity, float hitz) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IAgriCrop) {
            IAgriCrop crop = (IAgriCrop)te;
            Optional<AgriSeed> trowel_seed = AgriApi.getSeedRegistry().valueOf(stack);
            if (crop.isCrossCrop()) {
                return EnumActionResult.FAIL;
            }
            if (crop.hasSeed() && !trowel_seed.isPresent()) {
                int growthstage = Math.max(0, crop.getGrowthStage() - trowelDebuff);
                trowel_seed = Optional.ofNullable(crop.getSeed());
                crop.setSeed(null);
                if (trowel_seed.isPresent()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("agri_seed", trowel_seed.get().getPlant().getId());
                    tag.func_74768_a("agri_level", growthstage);
                    trowel_seed.get().getStat().writeToNBT(tag);
                    stack.func_77982_d(tag);
                    stack.func_77964_b(1);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (trowel_seed.isPresent() && !crop.hasSeed()) {
                if (crop.setSeed(trowel_seed.get())) {
                    int growthstage = StackHelper.getTag(stack).func_74762_e("agri_level");
                    crop.setGrowthStage(growthstage);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77964_b(0);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean isEnabled() {
        return enableTrowel;
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        return ImmutableList.of((Object)new Tuple((Object)0, (Object)new ModelResourceLocation(this.getRegistryName() + "")), (Object)new Tuple((Object)1, (Object)new ModelResourceLocation(this.getRegistryName() + "_full")));
    }
}

