/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.NBTHelper;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAgriSeed
extends ItemBase
implements IAgriAdapter<AgriSeed>,
IAutoRenderedItem {
    public ItemAgriSeed() {
        super("agri_seed");
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT_SEED);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            PlantStats baseStat = new PlantStats();
            for (IAgriPlant plant : AgriApi.getPlantRegistry().all()) {
                if (!plant.getSeedItems().stream().anyMatch(s -> s.isItemEqual((Item)this))) continue;
                ItemStack stack = new ItemStack((Item)this);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("agri_seed", plant.getId());
                baseStat.writeToNBT(tag);
                stack.func_77982_d(tag);
                list.add((Object)stack);
            }
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(stack);
        return seed.map(s -> s.getPlant().getSeedName()).orElse("Generic Seeds");
    }

    public List<String> getIgnoredNBT() {
        List tags = super.getIgnoredNBT();
        tags.add("agri_analyzed");
        tags.add("agri_growth");
        tags.add("agri_gain");
        tags.add("agri_strength");
        return tags;
    }

    @Override
    public boolean accepts(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        return tag != null && tag.func_74764_b("agri_seed") && AgriApi.getStatRegistry().hasAdapter(tag);
    }

    @Override
    public Optional<AgriSeed> valueOf(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        if (tag == null) {
            return Optional.empty();
        }
        IAgriPlant plant = AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_seed")).orElse(null);
        IAgriStat stat = AgriApi.getStatRegistry().valueOf(tag).orElse(null);
        if (plant != null && stat != null) {
            return Optional.of(new AgriSeed(plant, stat));
        }
        return Optional.empty();
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelId(ItemStack stack) {
        Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(stack);
        return seed.map(s -> s.getPlant().getId()).orElse("");
    }

    @SideOnly(value=Side.CLIENT)
    public String getBaseTexture(ItemStack stack) {
        return AgriApi.getSeedRegistry().valueOf(stack).map(s -> s.getPlant().getSeedTexture().toString()).orElse("agricraft:items/seed_unknown");
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getAllTextures() {
        Collection<IAgriPlant> plants = AgriApi.getPlantRegistry().all();
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(plants.size());
        textures.add(new ResourceLocation("agricraft:items/seed_unknown"));
        for (IAgriPlant p : AgriApi.getPlantRegistry().all()) {
            textures.add(p.getSeedTexture());
        }
        return textures;
    }
}

