/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.misc.IAgriPeripheralMethod;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegistry;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationEngine;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plugin.AgriPlugin;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatCalculator;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public final class PluginHandler {
    @Nonnull
    private static final Deque<IAgriPlugin> PLUGINS = new ConcurrentLinkedDeque<IAgriPlugin>();

    public static void preInit(FMLPreInitializationEvent event) {
        PLUGINS.addAll(PluginHandler.getInstances(event.getAsmData(), AgriPlugin.class, IAgriPlugin.class));
        PLUGINS.stream().peek(PluginHandler::logPlugin).filter(IAgriPlugin::isEnabled).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
    }

    public static void init() {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(IAgriPlugin::initPlugin);
    }

    public static void postInit() {
        PluginHandler.registerSoils(AgriApi.getSoilRegistry());
        PluginHandler.registerPlants(AgriApi.getPlantRegistry());
        PluginHandler.registerMutations(AgriApi.getMutationRegistry());
        PluginHandler.registerStats(AgriApi.getStatRegistry());
        PluginHandler.registerSeeds(AgriApi.getSeedRegistry());
        PluginHandler.registerFertilizers(AgriApi.getFertilizerRegistry());
        PluginHandler.registerStatCalculators(AgriApi.getStatCalculatorRegistry());
        PluginHandler.registerCrossStrategies(AgriApi.getMutationEngine());
        PluginHandler.registerPeripheralMethods(AgriApi.getPeripheralMethodRegistry());
    }

    public static void loadTextures(Consumer<ResourceLocation> registry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerTextures(registry));
    }

    public static void registerSoils(IAgriRegistry<IAgriSoil> soilRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerSoils(soilRegistry));
    }

    public static void registerPlants(IAgriRegistry<IAgriPlant> plantRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerPlants(plantRegistry));
    }

    public static void registerMutations(IAgriMutationRegistry mutationRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerMutations(mutationRegistry));
    }

    public static void registerStats(IAgriAdapterizer<IAgriStat> statRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerStats(statRegistry));
    }

    public static void registerSeeds(IAgriAdapterizer<AgriSeed> seedRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerSeeds(seedRegistry));
    }

    public static void registerFertilizers(IAgriAdapterizer<IAgriFertilizer> fertilizerRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerFertilizers(fertilizerRegistry));
    }

    public static void registerStatCalculators(IAgriAdapterizer<IAgriStatCalculator> calculatorRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerStatCalculators(calculatorRegistry));
    }

    public static void registerCrossStrategies(IAgriMutationEngine mutationEngine) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerCrossStrategies(mutationEngine));
    }

    public static void registerPeripheralMethods(IAgriRegistry<IAgriPeripheralMethod> methodRegistry) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerPeripheralMethods(methodRegistry));
    }

    @Nonnull
    private static <T> List<T> getInstances(ASMDataTable asm, Class anno, Class<T> type) {
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asm.getAll(anno.getCanonicalName())) {
            try {
                T instance = Class.forName(asmData.getClassName()).asSubclass(type).newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                AgriCore.getLogger("agricraft-plugins").debug("%nFailed to load AgriPlugin%n\tOf class: {0}!%n\tFor annotation: {1}!%n\tAs Instanceof: {2}!", asmData.getClassName(), anno.getCanonicalName(), type.getCanonicalName());
            }
        }
        return instances;
    }

    private static void logPlugin(IAgriPlugin plugin) {
        AgriCore.getLogger("agricraft").info("\nFound AgriCraft Plugin:\n\t- Id: {0}\n\t- Name: {1}\n\t- Status: {2}", plugin.getId(), plugin.getName(), plugin.isEnabled() ? "Enabled" : "Disabled");
    }
}

