/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.blocks.BlockGrate;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.utility.MessageUtil;
import com.infinityraider.infinitylib.utility.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="agricraft")
public class PlayerInteractEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void vanillaSeedPlanting(PlayerInteractEvent.RightClickBlock event) {
        if (!AgriCraftConfig.disableVanillaFarming) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!StackHelper.isValid(stack)) {
            return;
        }
        if (!AgriApi.getSeedRegistry().hasAdapter(stack)) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IAgriCrop) {
            return;
        }
        if (stack.func_77973_b() instanceof IPlantable && !block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)stack.func_77973_b())) {
            return;
        }
        if (WorldHelper.getTile((IBlockAccess)event.getWorld(), (BlockPos)event.getPos(), IAgriCrop.class).isPresent()) {
            return;
        }
        event.setUseItem(Event.Result.DENY);
        if (event.getSide().isClient()) {
            return;
        }
        if (AgriCraftConfig.showDisabledVanillaFarmingWarning) {
            MessageUtil.messagePlayer((EntityPlayer)event.getEntityPlayer(), (String)"`7Vanilla planting is disabled!`r", (Object[])new Object[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void waterPadCreation(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!StackHelper.isValid(stack, ItemSpade.class)) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150458_ak) {
            return;
        }
        event.setUseBlock(Event.Result.DENY);
        event.setUseItem(Event.Result.DENY);
        event.setResult(Event.Result.DENY);
        if (event.getSide().isClient()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        world.func_180501_a(pos, AgriBlocks.getInstance().WATER_PAD.func_176223_P(), 3);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyVinesToGrate(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!StackHelper.isValid(stack)) {
            return;
        }
        if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150395_bd)) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockGrate)) {
            return;
        }
        event.setUseItem(Event.Result.DENY);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void denyBonemeal(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        if (!event.getEntityPlayer().func_70093_af()) {
            return;
        }
        ItemStack heldItem = event.getEntityPlayer().func_184607_cu();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 15 && (te = event.getWorld().func_175625_s(event.getPos())) != null && te instanceof TileEntityCrop) {
            event.setUseItem(Event.Result.DENY);
        }
    }
}

