/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import com.infinityraider.agricraft.gui.IAgriGui;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import scala.actors.threadpool.Arrays;

public class ComponentGui<T extends Container>
implements IAgriGui<T> {
    @AgriConfigurable(key="Enable GUI Inspector", category=AgriConfigCategory.DEBUG, comment="Set to true to enable the GUI inspector for all AgriCraft GUIs.")
    public static boolean enableGuiInspector = false;
    private final int width;
    private final int height;
    private List<GuiComponent> components;
    private List<ResourceLocation> backgrounds;
    private final T container;
    private int lastMouseX;
    private int lastMouseY;

    public ComponentGui(int width, int height, T container) {
        this.width = width;
        this.height = height;
        this.components = new ArrayList<GuiComponent>();
        this.backgrounds = new ArrayList<ResourceLocation>();
        this.container = container;
        this.lastMouseX = -1;
        this.lastMouseY = -1;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    public final synchronized void resetMouse() {
        this.lastMouseX = -1;
        this.lastMouseY = -1;
    }

    public final synchronized List<GuiComponent> getComponents() {
        return new ArrayList<GuiComponent>(this.components);
    }

    public final synchronized List<ResourceLocation> getBackgrounds() {
        return new ArrayList<ResourceLocation>(this.backgrounds);
    }

    public final synchronized boolean addComponent(GuiComponent component) {
        return this.components.add(component);
    }

    public final synchronized boolean addBackground(ResourceLocation background) {
        return this.backgrounds.add(background);
    }

    public final synchronized boolean addComponents(GuiComponent ... components) {
        return this.components.addAll(Arrays.asList((Object[])components));
    }

    public final synchronized boolean addBackgrounds(ResourceLocation ... backgrounds) {
        return this.backgrounds.addAll(Arrays.asList((Object[])backgrounds));
    }

    public final synchronized boolean addComponents(Collection<GuiComponent> components) {
        return this.components.addAll(components);
    }

    public final synchronized boolean addBackgrounds(Collection<ResourceLocation> backgrounds) {
        return this.backgrounds.addAll(backgrounds);
    }

    public final synchronized boolean removeComponent(GuiComponent component) {
        return this.components.remove(component);
    }

    public final synchronized boolean removeBackground(ResourceLocation background) {
        return this.backgrounds.remove(background);
    }

    public final synchronized void clearComponents() {
        this.components = new ArrayList<GuiComponent>();
    }

    public final synchronized void clearBackgrounds() {
        this.backgrounds = new ArrayList<ResourceLocation>();
    }

    @Override
    public final synchronized void onGuiInit(AgriGuiWrapper wrapper) {
        this.resetMouse();
        this.onComponentGuiInit(wrapper);
    }

    protected synchronized void onComponentGuiInit(AgriGuiWrapper wrapper) {
    }

    @Override
    public final synchronized void onRenderBackground(AgriGuiWrapper wrapper, float f, int relMouseX, int relMouseY) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ResourceLocation r : this.backgrounds) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
            wrapper.func_73729_b(0, 0, 0, 0, this.width, this.height);
        }
        GlStateManager.func_179099_b();
    }

    @Override
    public final synchronized void onRenderForeground(AgriGuiWrapper wrapper, int relMouseX, int relMouseY) {
        this.components.stream().filter(c -> c.isVisable()).forEach(c -> this.onRenderComponent(wrapper, (GuiComponent)c, relMouseX, relMouseY));
    }

    @Override
    public final synchronized void onRenderToolTips(AgriGuiWrapper wrapper, List<String> tooltips, int relMouseX, int relMouseY) {
        this.components.stream().filter(c -> c.isVisable()).filter(c -> c.contains(relMouseX, relMouseY)).forEach(c -> this.onAddComponentToolTip(wrapper, (GuiComponent)c, tooltips, relMouseX, relMouseY));
        if (enableGuiInspector) {
            this.onRenderInspector(wrapper, tooltips, relMouseX, relMouseY);
        }
    }

    public final synchronized void onRenderComponent(AgriGuiWrapper wrapper, GuiComponent c, int relMouseX, int relMouseY) {
        c.renderComponent(wrapper);
        if (enableGuiInspector) {
            wrapper.drawRectangle(c.getBounds().x, c.getBounds().y, c.getBounds().width, c.getBounds().height, Color.MAGENTA.hashCode());
        }
    }

    public final synchronized void onAddComponentToolTip(AgriGuiWrapper wrapper, GuiComponent c, List<String> tooltips, int relMouseX, int relMouseY) {
        c.addToolTip(tooltips, (EntityPlayer)wrapper.field_146297_k.field_71439_g);
    }

    public final synchronized void onRenderInspector(AgriGuiWrapper wrapper, List<String> tooltips, int relMouseX, int relMouseY) {
        tooltips.add(ChatFormatting.DARK_AQUA + "Window:");
        tooltips.add(ChatFormatting.DARK_AQUA + " - ID: " + ((Container)this.container).field_75152_c);
        tooltips.add(ChatFormatting.DARK_AQUA + " - Dimensions: (" + wrapper.field_146294_l + ", " + wrapper.field_146295_m + ")");
        tooltips.add(ChatFormatting.DARK_AQUA + " - Pausing: " + wrapper.func_73868_f());
        tooltips.add(ChatFormatting.DARK_AQUA + "GUI:");
        tooltips.add(ChatFormatting.DARK_AQUA + " - Dimensions: (" + this.width + ", " + this.height + ")");
        tooltips.add(ChatFormatting.DARK_AQUA + " - Components: " + this.components.size());
        tooltips.add(ChatFormatting.DARK_AQUA + " - Backgrounds: " + this.backgrounds.size());
        tooltips.add(ChatFormatting.DARK_AQUA + " - ItemStacks: " + ((Container)this.container).field_75153_a.size());
        tooltips.add(ChatFormatting.DARK_AQUA + " - Item Slots: " + ((Container)this.container).field_75151_b.size());
        tooltips.add(ChatFormatting.DARK_AQUA + "Mouse:");
        tooltips.add(ChatFormatting.DARK_AQUA + " - Position   : (" + relMouseX + ", " + relMouseY + ")");
        tooltips.add(ChatFormatting.DARK_AQUA + "Hovered:");
        Optional<Object> optionalHovered = Optional.empty();
        for (int i = this.components.size() - 1; i > -1; --i) {
            if (!this.components.get(i).contains(relMouseX, relMouseY)) continue;
            optionalHovered = Optional.of(this.components.get(i));
            break;
        }
        if (optionalHovered.isPresent()) {
            GuiComponent hovered = (GuiComponent)optionalHovered.get();
            wrapper.drawRectangle(hovered.getBounds().x, hovered.getBounds().y, hovered.getBounds().width, hovered.getBounds().height, Color.YELLOW.hashCode());
            tooltips.add(ChatFormatting.DARK_AQUA + " - Component: " + Objects.toString(hovered.getComponent()));
            tooltips.add(ChatFormatting.DARK_AQUA + " - Position: (" + hovered.getBounds().x + ", " + hovered.getBounds().y + ")");
            tooltips.add(ChatFormatting.DARK_AQUA + " - Dimensions: (" + hovered.getBounds().width + ", " + hovered.getBounds().height + ")");
            tooltips.add(ChatFormatting.DARK_AQUA + " - Enabled: " + hovered.isEnabled());
            tooltips.add(ChatFormatting.DARK_AQUA + " - Visable: " + hovered.isVisable());
            tooltips.add(ChatFormatting.DARK_AQUA + " - Hovered: " + hovered.isHovered());
        } else {
            tooltips.add(ChatFormatting.DARK_AQUA + " - None");
        }
    }

    @Override
    public final synchronized void onMouseClicked(AgriGuiWrapper wrapper, int relMouseX, int relMouseY, int mouseButton) {
        this.components.stream().filter(c -> c.isEnabled()).filter(c -> c.contains(relMouseX, relMouseY)).anyMatch(c -> c.onClick(relMouseX, relMouseY, mouseButton));
    }

    @Override
    public final synchronized void onUpdateMouse(AgriGuiWrapper wrapper, int relMouseX, int relMouseY) {
        if (this.lastMouseX != relMouseX || this.lastMouseY != relMouseY) {
            this.components.stream().filter(c -> c.isEnabled()).forEach(c -> c.onMouseMove(relMouseX, relMouseY));
            this.lastMouseX = relMouseX;
            this.lastMouseY = relMouseY;
        }
    }

    static {
        AgriCore.getConfig().addConfigurable(ComponentGui.class);
    }
}

