/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.core;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriLoader;
import com.agricraft.agricore.plant.AgriMutation;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.util.ResourceHelper;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.core.JsonHelper;
import com.infinityraider.agricraft.core.JsonPlant;
import com.infinityraider.agricraft.core.JsonSoil;
import com.infinityraider.agricraft.core.ModConverter;
import com.infinityraider.agricraft.core.ModLogger;
import com.infinityraider.agricraft.core.ModProvider;
import com.infinityraider.agricraft.core.ModTranslator;
import com.infinityraider.agricraft.core.ModValidator;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CoreHandler {
    public static final Pattern JSON_FILE_PATTERN = Pattern.compile(".*\\.json", 2);
    public static final Pattern AGRI_FOLDER_PATTERN = Pattern.compile("json/defaults/.*", 2);
    private static Path configDir;
    private static Path jsonDir;
    private static Path defaultDir;
    private static Configuration config;

    private CoreHandler() {
    }

    public static Configuration getConfig() {
        return config;
    }

    public static Path getConfigDir() {
        return configDir;
    }

    public static Path getJsonDir() {
        return jsonDir;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        configDir = event.getSuggestedConfigurationFile().getParentFile().toPath().resolve("agricraft");
        config = new Configuration(configDir.resolve("config.cfg").toFile());
        jsonDir = configDir.resolve("json");
        defaultDir = jsonDir.resolve("defaults");
        ModProvider provider = new ModProvider(config);
        MinecraftForge.EVENT_BUS.register((Object)provider);
        AgriCore.init(new ModLogger(), new ModTranslator(), new ModValidator(), new ModConverter(), provider);
        ResourceHelper.findResources(JSON_FILE_PATTERN.asPredicate()).stream().filter(AGRI_FOLDER_PATTERN.asPredicate()).forEach(r -> ResourceHelper.copyResource(r, configDir.resolve((String)r), false));
        CoreHandler.loadJsons();
    }

    public static void init() {
        AgriCore.getConfig().save();
        CoreHandler.initSoils();
        CoreHandler.initPlants();
        CoreHandler.initMutations();
    }

    public static void loadJsons() {
        AgriCore.getLogger("agricraft").info("Attempting to read AgriCraft JSONs!", new Object[0]);
        AgriLoader.loadDirectory(defaultDir, AgriCore.getSoils(), AgriCore.getPlants(), AgriCore.getMutations());
        AgriCore.getLogger("agricraft").info("Finished trying to read AgriCraft JSONs!", new Object[0]);
    }

    public static void initSoils() {
        AgriCore.getLogger("agricraft").info("Registering Soils!", new Object[0]);
        int raw = AgriCore.getSoils().getAll().size();
        AgriCore.getSoils().validate();
        int count = AgriCore.getSoils().getAll().size();
        AgriCore.getSoils().getAll().stream().filter(AgriSoil::isEnabled).map(JsonSoil::new).forEach(AgriApi.getSoilRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Soils ({0}/{1}):", count, raw);
        for (IAgriSoil soil : AgriApi.getSoilRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", soil.getName());
        }
    }

    public static void initPlants() {
        AgriCore.getLogger("agricraft").info("Registering Plants!", new Object[0]);
        int raw = AgriCore.getPlants().getAll().size();
        AgriCore.getPlants().validate();
        int count = AgriCore.getPlants().getAll().size();
        AgriCore.getPlants().validate();
        AgriCore.getPlants().getAll().stream().filter(AgriPlant::isEnabled).map(JsonPlant::new).forEach(AgriApi.getPlantRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Plants ({0}/{1}):", count, raw);
        for (IAgriPlant plant : AgriApi.getPlantRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", plant.getPlantName());
        }
    }

    public static void initMutations() {
        AgriCore.getLogger("agricraft").info("Registering Mutations!", new Object[0]);
        int raw = AgriCore.getMutations().getAll().size();
        AgriCore.getMutations().validate();
        int count = AgriCore.getMutations().getAll().size();
        AgriCore.getMutations().getAll().stream().filter(AgriMutation::isEnabled).map(JsonHelper::wrap).filter(Optional::isPresent).map(Optional::get).forEach(AgriApi.getMutationRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Mutations ({0}/{1}):", count, raw);
        for (IAgriMutation mutation : AgriApi.getMutationRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", mutation);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadTextures(Consumer<ResourceLocation> consumer) {
        AgriCore.getPlants().getAll().stream().flatMap(plant -> plant.getTexture().getAllTextures().stream()).distinct().map(t -> new ResourceLocation(t)).forEach(consumer);
    }
}

