/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriStack;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class AgriProduct
extends AgriStack {
    private final int min;
    private final int max;
    private final double chance;
    private final boolean required;

    public AgriProduct() {
        this.min = 5;
        this.max = 5;
        this.chance = 0.99;
        this.required = true;
    }

    public AgriProduct(String item, int meta, int min, int max, double chance, boolean required, String ... ignoreTags) {
        this(item, meta, min, max, chance, required, Arrays.asList(ignoreTags));
    }

    public AgriProduct(String item, int meta, int min, int max, double chance, boolean required, List<String> ignoreTags) {
        super(item, meta, false, false, "", ignoreTags);
        this.min = min;
        this.max = max;
        this.chance = chance;
        this.required = required;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            AgriCore.getCoreLogger().info("Invalid Product: Invalid Item: {0}!", this.item);
            return false;
        }
        if (this.min < 1) {
            AgriCore.getCoreLogger().info("Invalid Product: Min Amount Less Than One!", new Object[0]);
            return false;
        }
        if (this.max < this.min) {
            AgriCore.getCoreLogger().info("Invalid Product: Min Amount Greater Than Max: {0} > {1}!", this.min, this.max);
            return false;
        }
        return true;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getChance() {
        return this.chance;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean shouldDrop(Random rand) {
        return this.chance > rand.nextDouble();
    }

    public int getAmount(Random rand) {
        return this.min + rand.nextInt(this.max - this.min + 1);
    }

    public <T> Optional<T> toStack(Class<T> token, Random rand) {
        return this.toStack(token, this.getAmount(rand));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nProduct:");
        sb.append("\n\t- ").append(super.toString().replaceAll("\n", "\n\t").trim());
        sb.append("\n\t- Min Amount: ").append(this.min);
        sb.append("\n\t- Max Amount: ").append(this.max);
        sb.append("\n\t- Probability: ").append(this.chance);
        return sb.toString();
    }
}

