/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.common.lexicon.page.PageText;

public class PageEntity
extends LexiconPage {
    Entity dummyEntity;
    int relativeMouseX;
    int relativeMouseY;
    boolean tooltipEntity;
    final int size;
    private Constructor<? extends Entity> entityConstructor;

    public PageEntity(String unlocalizedName, String entity, int size) {
        super(unlocalizedName);
        Class entityClass = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entity))).getEntityClass();
        this.size = size;
        try {
            this.entityConstructor = entityClass.getConstructor(World.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        this.prepDummy();
        int text_x = gui.getLeft() + 16;
        int text_y = gui.getTop() + gui.getHeight() - 40;
        int entity_scale = this.getEntityScale(this.size);
        int entity_x = gui.getLeft() + gui.getWidth() / 2;
        int entity_y = gui.getTop() + gui.getHeight() / 2 + MathHelper.func_76141_d((float)(this.dummyEntity.field_70131_O * (float)entity_scale / 2.0f));
        this.renderEntity(gui, this.dummyEntity, entity_x, entity_y, entity_scale, this.dummyEntity.field_70173_aa * 2);
        PageText.renderText(text_x, text_y, gui.getWidth() - 30, gui.getHeight(), this.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityScale(int targetSize) {
        float entity_size = this.dummyEntity.field_70130_N;
        if (this.dummyEntity.field_70130_N < this.dummyEntity.field_70131_O) {
            entity_size = this.dummyEntity.field_70131_O;
        }
        return MathHelper.func_76141_d((float)((float)this.size / entity_size));
    }

    @Override
    public void updateScreen() {
        this.prepDummy();
        ++this.dummyEntity.field_70173_aa;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderEntity(IGuiLexiconEntry gui, Entity entity, int x, int y, int scale, float rotation) {
        this.dummyEntity.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        if ((float)this.relativeMouseX >= (float)x - this.dummyEntity.field_70130_N * (float)scale / 2.0f - 10.0f && (float)this.relativeMouseY >= (float)y - this.dummyEntity.field_70131_O * (float)scale - 20.0f && (float)this.relativeMouseX <= (float)x + this.dummyEntity.field_70130_N * (float)scale / 2.0f + 10.0f && this.relativeMouseY <= y + 20) {
            this.tooltipEntity = true;
        }
    }

    public void prepDummy() {
        if (this.dummyEntity == null || this.dummyEntity.field_70128_L) {
            try {
                this.dummyEntity = this.entityConstructor.newInstance(Minecraft.func_71410_x().field_71441_e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

