/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemInfiniteFruit
extends ItemRelic
implements IManaUsingItem {
    public ItemInfiniteFruit() {
        super("infiniteFruit");
        this.func_185043_a(new ResourceLocation("botania", "boot"), (stack, worldIn, entityIn) -> ItemInfiniteFruit.isBoot(stack) ? 1.0f : 0.0f);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return ItemInfiniteFruit.isBoot(stack) ? EnumAction.DRINK : EnumAction.EAT;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(false) && this.isRightPlayer(player, stack)) {
            player.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        super.onUsingTick(stack, living, count);
        if (!(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        if (ManaItemHandler.requestManaExact(stack, player, 500, true)) {
            if (count % 5 == 0) {
                player.func_71024_bL().func_75122_a(1, 1.0f);
            }
            if (count == 5 && player.func_71043_e(false)) {
                player.field_184628_bn = 20;
            }
        }
    }

    private static boolean isBoot(ItemStack par1ItemStack) {
        String name = par1ItemStack.func_82833_r().toLowerCase(Locale.ROOT).trim();
        return name.equals("das boot");
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/infinite_fruit");
    }
}

