/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.thaumcraft;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.lib.LibOreDict;

public class TCAspects {
    private static final int ANY = Short.MAX_VALUE;
    private final AspectEventProxy proxy;
    private final List<ItemStack> brewContainers = Arrays.asList(new ItemStack(ModItems.vial), new ItemStack(ModItems.vial, 1, 1), new ItemStack(ModItems.incenseStick), new ItemStack(ModItems.bloodPendant));

    private TCAspects(AspectEventProxy proxy) {
        this.proxy = proxy;
    }

    @SubscribeEvent
    public static void registerAspects(AspectRegistryEvent event) {
        TCAspects handler = new TCAspects(event.register);
        handler.registerFlowerAspects();
        handler.registerItemAspects();
        handler.registerBrewAspects();
        handler.registerEntityAspects();
    }

    private void registerFlowerAspects() {
        this.registerFlower("puredaisy", new AspectList().add(Aspect.LIFE, 10).add(Aspect.EXCHANGE, 5));
        this.registerFlower("manastar", new AspectList().add(Aspect.SENSES, 5).add(Aspect.AURA, 5));
        this.registerFlower("endoflame", new AspectList().add(Aspect.FIRE, 10));
        this.registerFlower("hydroangeas", new AspectList().add(Aspect.WATER, 10));
        this.registerFlower("thermalily", new AspectList().add(Aspect.FIRE, 5).add(Aspect.EARTH, 5));
        this.registerFlower("arcanerose", new AspectList().add(Aspect.MIND, 15));
        this.registerFlower("munchdew", new AspectList().add(Aspect.PLANT, 5).add(Aspect.DESIRE, 5));
        this.registerFlower("entropinnyum", new AspectList().add(Aspect.ENTROPY, 5).add(Aspect.ALCHEMY, 5));
        this.registerFlower("kekimurus", new AspectList().add(Aspect.DESIRE, 10));
        this.registerFlower("gourmaryllis", new AspectList().add(Aspect.DESIRE, 5).add(Aspect.LIFE, 5));
        this.registerFlower("narslimmus", new AspectList().add(Aspect.WATER, 5).add(Aspect.LIFE, 5));
        this.registerFlower("spectrolus", new AspectList().add(Aspect.SENSES, 10).add(Aspect.BEAST, 5));
        this.registerFlower("rafflowsia", new AspectList().add(Aspect.VOID, 10));
        this.registerFlower("shulk_me_not", new AspectList().add(Aspect.FLIGHT, 5).add(Aspect.TRAP, 5));
        this.registerFlower("dandelifeon", new AspectList().add(Aspect.ORDER, 5).add(Aspect.MECHANISM, 5).add(Aspect.LIFE, 5));
        this.registerFlower("jadedAmaranthus", new AspectList().add(Aspect.LIFE, 5).add(Aspect.PLANT, 5).add(Aspect.SENSES, 5));
        this.registerFlower("bellethorn", new AspectList().add(Aspect.AVERSION, 10));
        this.registerFlower("dreadthorn", new AspectList().add(Aspect.AVERSION, 5).add(Aspect.BEAST, 5));
        this.registerFlower("heiseiDream", new AspectList().add(Aspect.SOUL, 5).add(Aspect.BEAST, 5));
        this.registerFlower("tigerseye", new AspectList().add(Aspect.MOTION, 5).add(Aspect.TRAP, 5));
        this.registerFlower("orechid", new AspectList().add(Aspect.DESIRE, 10).add(Aspect.METAL, 5).add(Aspect.EARTH, 5));
        this.registerFlower("orechidIgnem", new AspectList().add(Aspect.DESIRE, 10).add(Aspect.METAL, 5).add(Aspect.FIRE, 5));
        this.registerFlower("fallenKanade", new AspectList().add(Aspect.LIFE, 10));
        this.registerFlower("exoflame", new AspectList().add(Aspect.FIRE, 5).add(Aspect.MOTION, 5));
        this.registerFlower("agricarnation", new AspectList().add(Aspect.LIFE, 5).add(Aspect.PLANT, 5));
        this.registerFlower("hopperhock", new AspectList().add(Aspect.VOID, 5).add(Aspect.EXCHANGE, 5));
        this.registerFlower("tangleberrie", new AspectList().add(Aspect.TRAP, 10));
        this.registerFlower("jiyuulia", new AspectList().add(Aspect.PROTECT, 5).add(Aspect.TRAP, 5));
        this.registerFlower("rannuncarpus", new AspectList().add(Aspect.MAN, 5).add(Aspect.EXCHANGE, 5));
        this.registerFlower("hyacidus", new AspectList().add(Aspect.DEATH, 10));
        this.registerFlower("pollidisiac", new AspectList().add(Aspect.BEAST, 5).add(Aspect.DESIRE, 5));
        this.registerFlower("clayconia", new AspectList().add(Aspect.WATER, 5).add(Aspect.EXCHANGE, 5));
        this.registerFlower("loonium", new AspectList().add(Aspect.DESIRE, 10).add(Aspect.BEAST, 5).add(Aspect.UNDEAD, 5));
        this.registerFlower("daffomill", new AspectList().add(Aspect.MOTION, 10));
        this.registerFlower("vinculotus", new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.TRAP, 10));
        this.registerFlower("spectranthemum", new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.MOTION, 5));
        this.registerFlower("medumone", new AspectList().add(Aspect.TRAP, 5).add(Aspect.COLD, 5));
        this.registerFlower("marimorphosis", new AspectList().add(Aspect.EARTH, 5).add(Aspect.SENSES, 5));
        this.registerFlower("bubbell", new AspectList().add(Aspect.AIR, 5).add(Aspect.VOID, 5));
        this.registerFlower("solegnolia", new AspectList().add(Aspect.METAL, 5).add(Aspect.TRAP, 5));
        this.registerFlower("bergamute", new AspectList().add(Aspect.SENSES, 5).add(Aspect.TRAP, 5));
    }

    private void registerItemAspects() {
        this.register("livingwood", new AspectList().add(Aspect.PLANT, 20).add(Aspect.LIFE, 5));
        this.register("livingrock", new AspectList().add(Aspect.EARTH, 5).add(Aspect.LIFE, 3));
        this.register("ingotManasteel", new AspectList().add(Aspect.METAL, 10).add(Aspect.MAGIC, 5));
        this.register("manaPearl", new AspectList().add(Aspect.ELDRITCH, 10).add(Aspect.MAGIC, 5).add(Aspect.MOTION, 5));
        this.register("manaDiamond", new AspectList(new ItemStack(Items.field_151045_i)).add(Aspect.MAGIC, 5));
        this.register("powderMana", new AspectList().add(Aspect.ENERGY, 3).add(Aspect.MAGIC, 3));
        this.register(ModBlocks.pistonRelay, 0, new AspectList(new ItemStack((Block)Blocks.field_150331_J)).add(Aspect.AURA, 10));
        this.register(ModItems.manaCookie, 0, new AspectList(new ItemStack(Items.field_151106_aX)).merge(Aspect.LIFE, 20).add(Aspect.MAGIC, 5));
        AspectList grassSeedAspects = new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5).add(Aspect.EXCHANGE, 2);
        this.register(ModItems.grassSeeds, 0, grassSeedAspects);
        this.register(ModItems.grassSeeds, 1, grassSeedAspects);
        this.register(ModItems.grassSeeds, 2, grassSeedAspects.copy().add(Aspect.DARKNESS, 5).add(Aspect.FLUX, 1));
        this.register(ModItems.quartz, 1, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.MAGIC, 2));
        this.register(ModBlocks.tinyPotato, Short.MAX_VALUE, new AspectList(new ItemStack(Items.field_151174_bG)).add(Aspect.LIFE, 5).add(Aspect.MOTION, 2));
        this.register(ModItems.manaInkwell, Short.MAX_VALUE, new AspectList().add(Aspect.SENSES, 5).add(Aspect.MAGIC, 5).add(Aspect.WATER, 2).add(Aspect.BEAST, 1));
        this.register(ModBlocks.manaGlass, 0, new AspectList(new ItemStack(Blocks.field_150359_w)).add(Aspect.LIGHT, 5).add(Aspect.MAGIC, 1));
        this.register(ModItems.manaResource, 16, new AspectList(new ItemStack(Items.field_151007_F)).merge(Aspect.CRAFT, 2).add(Aspect.MAGIC, 2));
        this.register(ModItems.manaBottle, Short.MAX_VALUE, new AspectList().add(Aspect.MAGIC, 5).add(Aspect.CRYSTAL, 5));
        this.register("dreamwood", new AspectList().add(Aspect.PLANT, 20).add(Aspect.ELDRITCH, 3));
        this.register("ingotElvenElementium", new AspectList().add(Aspect.METAL, 10).add(Aspect.ELDRITCH, 5));
        this.register("elvenPixieDust", new AspectList(new ItemStack(Items.field_151079_bi)).add(Aspect.MAGIC, 10));
        this.register("elvenDragonstone", new AspectList(new ItemStack(Items.field_151045_i)).add(Aspect.ELDRITCH, 10));
        this.register(ModItems.quartz, 5, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.ELDRITCH, 1));
        this.register(ModBlocks.elfGlass, 0, new AspectList(new ItemStack(Blocks.field_150359_w)).add(Aspect.LIGHT, 5).add(Aspect.ELDRITCH, 1));
        AspectList runeAspects = new AspectList().add(Aspect.EARTH, 5).add(Aspect.MAGIC, 5);
        this.register(ModItems.rune, 0, runeAspects.copy().add(Aspect.WATER, 25));
        this.register(ModItems.rune, 1, runeAspects.copy().add(Aspect.FIRE, 25));
        this.register(ModItems.rune, 2, runeAspects.copy().add(Aspect.EARTH, 25));
        this.register(ModItems.rune, 3, runeAspects.copy().add(Aspect.AIR, 25));
        this.register(ModItems.rune, 4, runeAspects.copy().add(Aspect.LIFE, 10).add(Aspect.PLANT, 15));
        this.register(ModItems.rune, 5, runeAspects.copy().add(Aspect.LIFE, 10).add(Aspect.FIRE, 15));
        this.register(ModItems.rune, 6, runeAspects.copy().add(Aspect.LIFE, 10).add(Aspect.DEATH, 15));
        this.register(ModItems.rune, 7, runeAspects.copy().add(Aspect.LIFE, 10).add(Aspect.COLD, 15));
        this.register(ModItems.rune, 8, runeAspects.copy().add(Aspect.AURA, 25));
        this.register(ModItems.rune, 9, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.MAN, 15));
        this.register(ModItems.rune, 10, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.LIFE, 15));
        this.register(ModItems.rune, 11, runeAspects.copy().add(Aspect.DESIRE, 25));
        this.register(ModItems.rune, 12, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.TRAP, 15));
        this.register(ModItems.rune, 13, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.AVERSION, 15));
        this.register(ModItems.rune, 14, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.EXCHANGE, 15));
        this.register(ModItems.rune, 15, runeAspects.copy().add(Aspect.DESIRE, 10).add(Aspect.SENSES, 15));
        this.register("ingotTerrasteel", new AspectList().add(Aspect.METAL, 15).add(Aspect.MAGIC, 20).add(Aspect.EARTH, 10));
        this.register("eternalLifeEssence", new AspectList().add(Aspect.LIFE, 15).add(Aspect.EARTH, 10).add(Aspect.SOUL, 10).add(Aspect.ORDER, 5).add(Aspect.MAGIC, 5).add(Aspect.ELDRITCH, 5));
        this.register("bEnderAirBottle", new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.AIR, 5));
        this.register("bPlaceholder", new AspectList().add(Aspect.CRAFT, 1));
        for (String name : LibOreDict.FLOWER) {
            this.register(name, new AspectList(new ItemStack((Block)Blocks.field_150328_O)));
        }
        for (String name : LibOreDict.DOUBLE_FLOWER) {
            this.register(name, new AspectList(new ItemStack((Block)Blocks.field_150398_cm)));
        }
        for (String name : LibOreDict.PETAL) {
            this.register(name, new AspectList().add(Aspect.SENSES, 5).add(Aspect.PLANT, 5));
        }
        for (int i = 0; i < 15; ++i) {
            this.register(ModItems.dye, i, new AspectList().add(Aspect.SENSES, 5).add(Aspect.PLANT, 1));
        }
        this.registerComplex(ModItems.lexicon, 0, new AspectList().add(Aspect.MAGIC, 5).add(Aspect.MIND, 10));
        this.registerComplex(ModItems.pestleAndMortar, 0, new AspectList().add(Aspect.TOOL, 4));
        this.register("livingwoodTwig", new AspectList().add(Aspect.PLANT, 8).add(Aspect.LIFE, 4));
        this.register("dreamwoodTwig", new AspectList().add(Aspect.PLANT, 8).add(Aspect.ELDRITCH, 4));
        this.registerComplex(ModItems.twigWand, 0, new AspectList().add(Aspect.TOOL, 8));
        this.registerComplex(ModItems.lens, 1, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.lens, 2, new AspectList().add(Aspect.ENERGY, 10));
        this.registerComplex(ModItems.lens, 3, new AspectList().add(Aspect.PROTECT, 10));
        this.registerComplex(ModItems.lens, 4, new AspectList().add(Aspect.TRAP, 10));
        this.registerComplex(ModItems.lens, 5, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.lens, 6, new AspectList().add(Aspect.EARTH, 10));
        this.registerComplex(ModItems.lens, 7, new AspectList().add(Aspect.TOOL, 10));
        this.registerComplex(ModItems.lens, 8, new AspectList().add(Aspect.AVERSION, 10));
        this.registerComplex(ModItems.lens, 9, new AspectList().add(Aspect.ELDRITCH, 10));
        this.registerComplex(ModItems.lens, 10, new AspectList().add(Aspect.DESIRE, 10));
        this.registerComplex(ModItems.lens, 11, new AspectList().add(Aspect.ENTROPY, 10));
        this.registerComplex(ModItems.lens, 12, new AspectList().add(Aspect.DESIRE, 10));
        this.registerComplex(ModItems.lens, 13, new AspectList().add(Aspect.METAL, 10));
        this.registerComplex(ModItems.lens, 14, new AspectList().add(Aspect.SENSES, 10));
        this.registerComplex(ModItems.lens, 15, new AspectList().add(Aspect.FIRE, 10));
        this.registerComplex(ModItems.lens, 16, new AspectList().add(Aspect.MECHANISM, 10));
        this.registerComplex(ModItems.lens, 18, new AspectList().add(Aspect.ELDRITCH, 10));
        this.registerComplex(ModItems.lens, 19, new AspectList().add(Aspect.SOUL, 10));
        this.registerComplex(ModItems.lens, 20, new AspectList().add(Aspect.MAN, 10));
        this.registerComplex(ModItems.lens, 21, new AspectList().add(Aspect.LIGHT, 5).add(Aspect.SENSES, 5));
        this.registerComplex(ModItems.lens, 22, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.lens, 23, new AspectList().add(Aspect.MAN, 10));
        this.registerComplex(ModItems.terraformRod, 0, new AspectList().add(Aspect.EXCHANGE, 15));
        this.registerComplex(ModItems.rainbowRod, 0, new AspectList().add(Aspect.SENSES, 10).add(Aspect.LIGHT, 10));
        this.registerComplex(ModItems.tornadoRod, 0, new AspectList().add(Aspect.FLIGHT, 20));
        this.registerComplex(ModItems.diviningRod, 0, new AspectList().add(Aspect.SENSES, 20));
        this.registerComplex(ModItems.gravityRod, 0, new AspectList().add(Aspect.MOTION, 20));
        this.registerComplex(ModItems.missileRod, 0, new AspectList().add(Aspect.AVERSION, 30));
        this.registerComplex(ModItems.cobbleRod, 0, new AspectList().add(Aspect.EARTH, 20));
        this.registerComplex(ModItems.exchangeRod, 0, new AspectList().add(Aspect.EXCHANGE, 30));
        this.register("bRedString", new AspectList().add(Aspect.ENERGY, 30).add(Aspect.EXCHANGE, 20).add(Aspect.ELDRITCH, 15).add(Aspect.MECHANISM, 15).add(Aspect.MAGIC, 10));
        this.registerComplex(ModItems.manaTablet, Short.MAX_VALUE, new AspectList().add(Aspect.VOID, 5).add(Aspect.MAGIC, 5));
        this.registerComplex(ModItems.fertilizer, 0, new AspectList().add(Aspect.LIFE, 4));
        this.registerComplex(ModItems.grassHorn, 0, new AspectList().add(Aspect.SENSES, 10).add(Aspect.TOOL, 8));
        this.register(ModItems.manaMirror, Short.MAX_VALUE, new AspectList().add(Aspect.EARTH, 10).add(Aspect.PLANT, 10).add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 5).add(Aspect.MAGIC, 10).add(Aspect.METAL, 10));
        this.registerComplex(ModItems.travelBelt, 0, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.magnetRing, 0, new AspectList().add(Aspect.DESIRE, 10));
        this.registerComplex(ModItems.flightTiara, Short.MAX_VALUE, new AspectList().add(Aspect.FLIGHT, 38));
        if (ConfigHandler.darkQuartzEnabled) {
            this.register(ModItems.quartz, 0, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.ENERGY, 1).add(Aspect.DARKNESS, 1));
        }
        this.register(ModItems.quartz, 2, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.FIRE, 1).add(Aspect.ALCHEMY, 1));
        this.register(ModItems.quartz, 3, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.SENSES, 1).add(Aspect.PLANT, 1));
        this.register(ModItems.quartz, 4, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.ENERGY, 2));
        this.register(ModItems.quartz, 6, new AspectList(new ItemStack(Items.field_151128_bU)).add(Aspect.SENSES, 1).add(Aspect.PLANT, 1));
        this.registerComplex(ModItems.openBucket, 0, new AspectList().add(Aspect.VOID, 15));
        this.registerComplex(ModItems.pixieRing, 0, new AspectList().add(Aspect.AURA, 5).add(Aspect.FLIGHT, 5));
        this.registerComplex(ModItems.superTravelBelt, 0, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.laputaShard, Short.MAX_VALUE, new AspectList().add(Aspect.FLIGHT, 20));
        this.registerComplex(ModItems.itemFinder, 0, new AspectList().add(Aspect.SENSES, 20));
        this.register(ModItems.enderHand, 0, new AspectList(new ItemStack(Blocks.field_150477_bB)).add(Aspect.BEAST, 15));
        this.register(ModItems.spark, 0, new AspectList().add(Aspect.AURA, 15).add(Aspect.MOTION, 15).add(Aspect.FIRE, 10).add(Aspect.SENSES, 10));
        this.register(ModItems.vial, 0, new AspectList(new ItemStack(ModBlocks.manaGlass)).add(Aspect.VOID, 2));
        this.register(ModItems.vial, 1, new AspectList(new ItemStack(ModBlocks.elfGlass)).add(Aspect.VOID, 3));
        this.registerComplex(ModItems.holyCloak, 0, new AspectList().add(Aspect.PROTECT, 15));
        this.registerComplex(ModItems.unholyCloak, 0, new AspectList().add(Aspect.AVERSION, 15));
        this.registerComplex(ModItems.balanceCloak, 0, new AspectList().add(Aspect.PROTECT, 10).add(Aspect.AVERSION, 10));
        this.registerComplex(ModItems.craftingHalo, 0, new AspectList().add(Aspect.CRAFT, 15));
        this.register(ModItems.blackLotus, 0, new AspectList().add(Aspect.MAGIC, 10).add(Aspect.ORDER, 10).add(Aspect.ELDRITCH, 5));
        this.register(ModItems.blackLotus, 1, new AspectList().add(Aspect.MAGIC, 30).add(Aspect.ORDER, 20).add(Aspect.ELDRITCH, 10));
        this.registerComplex(ModItems.monocle, 0, new AspectList().add(Aspect.SENSES, 10));
        this.register(ModItems.clip, 0, new AspectList(new ItemStack(ModBlocks.dreamwood)).add(Aspect.VOID, 5).add(Aspect.MECHANISM, 2));
        this.registerComplex(ModItems.worldSeed, 0, new AspectList().add(Aspect.MOTION, 10).add(Aspect.PLANT, 5).add(Aspect.ELDRITCH, 3));
        this.registerComplex(ModItems.thornChakram, 0, new AspectList().add(Aspect.AVERSION, 12).add(Aspect.DEATH, 6));
        this.registerComplex(ModItems.thornChakram, 1, new AspectList().merge(Aspect.AVERSION, 7));
        this.register(ModItems.overgrowthSeed, 0, new AspectList().add(Aspect.LIFE, 30).add(Aspect.MAGIC, 25));
        this.register(ModItems.craftPattern, Short.MAX_VALUE, new AspectList().add(Aspect.CRAFT, 10).add(Aspect.ENERGY, 10));
        this.registerComplex(ModItems.swapRing, 0, new AspectList().add(Aspect.TOOL, 8).add(Aspect.EXCHANGE, 8));
        this.registerComplex(ModItems.flowerBag, 0, new AspectList().add(Aspect.VOID, 5));
        this.registerComplex(ModItems.phantomInk, 0, new AspectList().add(Aspect.SENSES, 9).add(Aspect.VOID, 4));
        this.register(ModItems.corporeaSpark, 0, new AspectList().add(Aspect.AURA, 15).add(Aspect.MOTION, 15).add(Aspect.SENSES, 10).add(Aspect.EXCHANGE, 15).add(Aspect.ELDRITCH, 10));
        AspectList willAspects = new AspectList().add(Aspect.MAGIC, 10).add(Aspect.AVERSION, 10).add(Aspect.SOUL, 10);
        this.register(ModItems.ancientWill, 0, willAspects.copy().add(Aspect.PROTECT, 10));
        this.register(ModItems.ancientWill, 1, willAspects.copy().add(Aspect.BEAST, 10));
        this.register(ModItems.ancientWill, 2, willAspects.copy().add(Aspect.UNDEAD, 10));
        this.register(ModItems.ancientWill, 3, willAspects.copy().add(Aspect.TRAP, 10));
        this.register(ModItems.ancientWill, 4, willAspects.copy().add(Aspect.DEATH, 10));
        this.register(ModItems.ancientWill, 5, willAspects.copy().add(Aspect.FLUX, 10));
        this.register(ModItems.pinkinator, 0, new AspectList().add(Aspect.LIFE, 30).add(Aspect.ORDER, 20).add(Aspect.EXCHANGE, 20));
        AspectList relicAspects = new AspectList().add(Aspect.MAGIC, 30).add(Aspect.DESIRE, 25).add(Aspect.ELDRITCH, 15);
        this.register(ModItems.dice, 0, relicAspects.copy().add(Aspect.ELDRITCH, 15));
        this.register(ModItems.infiniteFruit, 0, relicAspects.copy().add(Aspect.LIFE, 50).add(Aspect.PLANT, 30));
        this.register(ModItems.kingKey, 0, relicAspects.copy().add(Aspect.AVERSION, 50).add(Aspect.TRAP, 30));
        this.register(ModItems.flugelEye, 0, relicAspects.copy().add(Aspect.MOTION, 50).add(Aspect.FLIGHT, 30));
        this.register(ModItems.thorRing, 0, relicAspects.copy().add(Aspect.TOOL, 50).add(Aspect.ENTROPY, 30));
        this.register(ModItems.odinRing, 0, relicAspects.copy().add(Aspect.PROTECT, 50).add(Aspect.LIFE, 30));
        this.register(ModItems.lokiRing, 0, relicAspects.copy().add(Aspect.AURA, 50).add(Aspect.MAN, 30));
        this.register(ModItems.recordGaia1, 0, new AspectList().add(Aspect.SENSES, 15).add(Aspect.DESIRE, 10).add(Aspect.AIR, 5).add(Aspect.VOID, 5));
        this.register(ModItems.recordGaia2, 0, new AspectList().add(Aspect.SENSES, 15).add(Aspect.DESIRE, 10).add(Aspect.AIR, 5).add(Aspect.AVERSION, 5));
        this.registerComplex(ModItems.blackHoleTalisman, 0, new AspectList().add(Aspect.VOID, 30));
        this.registerComplex(ModItems.temperanceStone, Short.MAX_VALUE, new AspectList().add(Aspect.TRAP, 5));
        this.registerComplex(ModItems.obedienceStick, 0, new AspectList().add(Aspect.TOOL, 4));
        this.registerComplex(ModItems.slimeBottle, 0, new AspectList(new ItemStack(Items.field_151123_aH)).add(Aspect.SENSES, 10));
        this.registerComplex(ModItems.magnetRingGreater, 0, new AspectList().add(Aspect.DESIRE, 15));
        this.registerComplex(ModItems.thunderSword, 0, new AspectList().add(Aspect.ENERGY, 15));
        this.registerComplex(ModItems.autocraftingHalo, 0, new AspectList().add(Aspect.CRAFT, 15).add(Aspect.EXCHANGE, 10));
        this.register(ModItems.gaiaHead, 0, new AspectList().add(Aspect.DEATH, 10).add(Aspect.SOUL, 15).add(Aspect.ELDRITCH, 10).add(Aspect.EARTH, 10));
        this.registerComplex(ModItems.sextant, 0, new AspectList().add(Aspect.TOOL, 8));
        this.registerComplex(ModItems.speedUpBelt, 0, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.baubleBox, 0, new AspectList().add(Aspect.VOID, 5));
        this.registerComplex(ModItems.dodgeRing, 0, new AspectList().add(Aspect.MOTION, 10));
        this.registerComplex(ModItems.invisibilityCloak, 0, new AspectList().add(Aspect.SENSES, 15));
        this.registerComplex(ModBlocks.altar, 0, new AspectList().add(Aspect.CRAFT, 10));
        this.registerComplex(ModBlocks.runeAltar, 0, new AspectList().add(Aspect.CRAFT, 10).add(Aspect.MAGIC, 5));
        this.registerComplex(ModBlocks.spreader, 0, new AspectList().add(Aspect.MOTION, 10).add(Aspect.MAGIC, 10));
        this.registerComplex(ModBlocks.spreader, 1, new AspectList(new ItemStack(ModBlocks.spreader)).add(Aspect.ENERGY, 10).add(Aspect.MECHANISM, 5));
        this.registerComplex(ModBlocks.spreader, 2, new AspectList().add(Aspect.MOTION, 15).add(Aspect.MAGIC, 15));
        this.registerComplex(ModBlocks.spreader, 3, new AspectList().add(Aspect.MOTION, 8).add(Aspect.MAGIC, 8).add(Aspect.SENSES, 10));
        this.registerComplex(ModBlocks.pool, 0, new AspectList().add(Aspect.VOID, 10).add(Aspect.MAGIC, 5));
        this.registerComplex(ModBlocks.pool, 2, new AspectList().add(Aspect.VOID, 3).add(Aspect.MAGIC, 3));
        this.register(ModBlocks.bifrostPerm, 0, new AspectList(new ItemStack(ModBlocks.elfGlass)).add(Aspect.SENSES, 5));
        this.registerComplex(ModBlocks.pool, 3, new AspectList().add(Aspect.VOID, 10).add(Aspect.MAGIC, 5));
        this.registerComplex(ModBlocks.distributor, 0, new AspectList().add(Aspect.MECHANISM, 5).add(Aspect.MAGIC, 5));
        this.registerComplex(ModBlocks.manaVoid, 0, new AspectList().add(Aspect.VOID, 20));
        this.registerComplex(ModBlocks.manaDetector, 0, new AspectList().add(Aspect.SENSES, 10));
        this.register(ModBlocks.enchanter, 0, new AspectList(new ItemStack(Blocks.field_150368_y)).add(Aspect.MAGIC, 25).add(Aspect.CRAFT, 15));
        this.registerComplex(ModBlocks.tinyPlanet, 0, new AspectList().add(Aspect.EARTH, 50));
        this.registerComplex(ModBlocks.openCrate, 0, new AspectList().add(Aspect.VOID, 5));
        this.registerComplex(ModBlocks.openCrate, 1, new AspectList().add(Aspect.MECHANISM, 5));
        this.registerComplex(ModBlocks.forestEye, 0, new AspectList().add(Aspect.SENSES, 10).add(Aspect.BEAST, 10));
        this.registerComplex(ModBlocks.forestDrum, 1, new AspectList().add(Aspect.SENSES, 5).add(Aspect.TOOL, 5));
        this.register(ModBlocks.bifrost, 0, new AspectList(new ItemStack(ModBlocks.bifrostPerm)));
        this.registerComplex(ModBlocks.floatingFlower, Short.MAX_VALUE, new AspectList().add(Aspect.FLIGHT, 5));
        this.registerComplex(ModBlocks.spawnerClaw, 0, new AspectList().add(Aspect.LIFE, 30));
        this.registerComplex(ModBlocks.alfPortal, 0, new AspectList().merge(Aspect.EXCHANGE, 20).add(Aspect.ELDRITCH, 20));
        this.register(ModBlocks.customBrick, Short.MAX_VALUE, new AspectList(new ItemStack(Blocks.field_150371_ca)).add(Aspect.SENSES, 3).add(Aspect.DESIRE, 1).add(Aspect.EARTH, 1));
        this.registerComplex(ModBlocks.enderEye, 0, new AspectList().add(Aspect.MECHANISM, 10));
        this.registerComplex(ModBlocks.starfield, 0, new AspectList().add(Aspect.DARKNESS, 20).add(Aspect.LIGHT, 20));
        this.registerComplex(ModBlocks.rfGenerator, 0, new AspectList().add(Aspect.MECHANISM, 20));
        this.registerComplex(ModBlocks.terraPlate, 0, new AspectList().add(Aspect.CRAFT, 20).add(Aspect.EXCHANGE, 20));
        this.register(ModBlocks.enchantedSoil, 0, new AspectList().add(Aspect.LIFE, 20).add(Aspect.MAGIC, 15).add(Aspect.EARTH, 10));
        AspectList corporeaAspects = new AspectList(new ItemStack(ModItems.corporeaSpark)).add(Aspect.MECHANISM, 15).merge(Aspect.ELDRITCH, 15).remove(Aspect.AURA);
        this.register(ModBlocks.corporeaIndex, 0, corporeaAspects.copy().add(Aspect.DESIRE, 25).add(Aspect.MIND, 25));
        this.register(ModBlocks.corporeaCrystalCube, 0, corporeaAspects.copy().add(Aspect.SENSES, 15).add(Aspect.CRYSTAL, 15));
        this.register(ModBlocks.corporeaFunnel, 0, corporeaAspects.copy().add(Aspect.DESIRE, 20));
        this.register(ModBlocks.corporeaInterceptor, 0, corporeaAspects.copy().add(Aspect.ENERGY, 20));
        this.register(ModBlocks.corporeaRetainer, 0, corporeaAspects.copy().add(Aspect.VOID, 20));
        this.registerComplex(ModBlocks.pump, 0, new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.EXCHANGE, 10));
        this.registerComplex(ModBlocks.incensePlate, 0, new AspectList().add(Aspect.ALCHEMY, 15));
        this.registerComplex(ModBlocks.hourglass, 0, new AspectList().add(Aspect.MECHANISM, 10));
        this.registerComplex(ModBlocks.ghostRail, 0, new AspectList().add(Aspect.SOUL, 10));
        this.registerComplex(ModBlocks.sparkChanger, 0, new AspectList().add(Aspect.MECHANISM, 10));
        this.register(ModBlocks.felPumpkin, 0, new AspectList().add(Aspect.ENTROPY, 15).add(Aspect.SOUL, 10).add(Aspect.LIFE, 5).add(Aspect.BEAST, 5).add(Aspect.PLANT, 5));
        this.registerComplex(ModBlocks.cocoon, 0, new AspectList().add(Aspect.LIFE, 10));
        this.registerComplex(ModBlocks.lightRelay, 0, new AspectList().add(Aspect.MOTION, 15));
        this.register(ModBlocks.cacophonium, 0, new AspectList(new ItemStack(Blocks.field_150323_B)).add(Aspect.DESIRE, 10));
        this.registerComplex(ModBlocks.teruTeruBozu, 0, new AspectList().add(Aspect.EXCHANGE, 10).add(Aspect.SENSES, 10));
        this.registerComplex(ModBlocks.avatar, 0, new AspectList().add(Aspect.MECHANISM, 15).add(Aspect.MAN, 10));
        this.register(ModBlocks.altGrass, Short.MAX_VALUE, new AspectList(new ItemStack((Block)Blocks.field_150349_c)).add(Aspect.SENSES, 3));
        this.registerComplex(ModBlocks.animatedTorch, 0, new AspectList().add(Aspect.MOTION, 5));
        this.register(ModBlocks.livingrock, 2, new AspectList(new ItemStack(ModBlocks.livingrock, 1, 1)).add(Aspect.PLANT, 3));
        this.register(ModBlocks.livingrock, 3, new AspectList(new ItemStack(ModBlocks.livingrock, 1, 1)).add(Aspect.ENTROPY, 1));
        this.register(ModBlocks.livingrock, 4, new AspectList(new ItemStack(ModBlocks.livingrock, 1, 1)).add(Aspect.ORDER, 1));
        AspectList stoneAspects = new AspectList().add(Aspect.EARTH, 5);
        this.register(ModFluffBlocks.biomeStoneA, 0, stoneAspects.copy().add(Aspect.PLANT, 1));
        this.register(ModFluffBlocks.biomeStoneA, 1, stoneAspects.copy().add(Aspect.AIR, 1));
        this.register(ModFluffBlocks.biomeStoneA, 2, stoneAspects.copy().add(Aspect.EARTH, 1));
        this.register(ModFluffBlocks.biomeStoneA, 3, stoneAspects.copy().add(Aspect.FLUX, 1));
        this.register(ModFluffBlocks.biomeStoneA, 4, stoneAspects.copy().add(Aspect.WATER, 1));
        this.register(ModFluffBlocks.biomeStoneA, 5, stoneAspects.copy().add(Aspect.ENTROPY, 1));
        this.register(ModFluffBlocks.biomeStoneA, 6, stoneAspects.copy().add(Aspect.COLD, 1));
        this.register(ModFluffBlocks.biomeStoneA, 7, stoneAspects.copy().add(Aspect.FIRE, 1));
        for (int i = 0; i < 8; ++i) {
            this.register(ModFluffBlocks.biomeStoneA, i + 8, new AspectList(new ItemStack(ModFluffBlocks.biomeStoneA, 1, i)).add(Aspect.ENTROPY, 1));
            this.register(ModFluffBlocks.biomeStoneB, i + 8, new AspectList(new ItemStack(ModFluffBlocks.biomeStoneB, 1, i)).add(Aspect.ORDER, 1));
        }
        if (ConfigHandler.registerGogResources) {
            this.register(ModItems.waterBowl, 0, new AspectList(new ItemStack(Items.field_151054_z)).add(Aspect.WATER, 10));
            this.register("pebble", new AspectList().add(Aspect.EARTH, 1));
            this.register(ModBlocks.root, 0, new AspectList().add(Aspect.PLANT, 15).add(Aspect.LIFE, 5));
            this.register(ModItems.manaResource, 20, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 2));
        }
    }

    private void registerBrewAspects() {
        for (RecipeBrew brewRecipe : BotaniaAPI.brewRecipes) {
            AspectList aspects = new AspectList();
            for (Object input : brewRecipe.getInputs()) {
                ItemStack toAdd = ItemStack.field_190927_a;
                if (input instanceof ItemStack) {
                    toAdd = (ItemStack)input;
                } else if (input instanceof String) {
                    toAdd = (ItemStack)OreDictionary.getOres((String)((String)input)).get(0);
                }
                AspectList ingredientAspects = AspectHelper.getObjectAspects((ItemStack)toAdd);
                for (Aspect a : ingredientAspects.getAspects()) {
                    aspects.add(a, ingredientAspects.getAmount(a));
                }
            }
            for (Aspect aspect : aspects.getAspects()) {
                aspects.reduce(aspect, aspects.getAmount(aspect) / 2);
            }
            aspects.add(Aspect.ALCHEMY, 8);
            for (ItemStack brewContainer : this.brewContainers) {
                ItemStack brewed = brewRecipe.getOutput(brewContainer);
                if (brewed.func_190926_b()) continue;
                this.proxy.registerObjectTag(brewed, new AspectList().add(aspects));
            }
        }
    }

    private void registerEntityAspects() {
        this.registerEntity("botania:manaBurst", new AspectList().add(Aspect.ENERGY, 5).add(Aspect.MOTION, 5).add(Aspect.AURA, 5));
        this.registerEntity("botania:pixie", new AspectList().add(Aspect.FLIGHT, 5).add(Aspect.ELDRITCH, 5).add(Aspect.LIGHT, 5));
        this.registerEntity("botania:flameRing", new AspectList().add(Aspect.FIRE, 20));
        this.registerEntity("botania:doppleganger", new AspectList().add(Aspect.MAN, 30).add(Aspect.EARTH, 30).add(Aspect.DARKNESS, 30).add(Aspect.ELDRITCH, 30).add(Aspect.PROTECT, 30));
        this.registerEntity("botania:magicLandmine", new AspectList().add(Aspect.AVERSION, 10).add(Aspect.DEATH, 10));
        this.registerEntity("botania:magicMissile", new AspectList().add(Aspect.AVERSION, 5).add(Aspect.MAGIC, 5));
        this.registerEntity("botania:pinkWither", new AspectList().add(Aspect.LIFE, 50).add(Aspect.UNDEAD, 30).add(Aspect.ORDER, 25).add(Aspect.FIRE, 25));
        this.registerEntity("botania:playerMover", new AspectList().add(Aspect.MOTION, 15).add(Aspect.LIGHT, 5));
        this.registerEntity("botania:manaStorm", new AspectList().add(Aspect.ENTROPY, 150).add(Aspect.FIRE, 100).add(Aspect.MAGIC, 50).add(Aspect.ALCHEMY, 50));
        this.registerEntity("botania:babylonWeapon", new AspectList().add(Aspect.AVERSION, 30).add(Aspect.ELDRITCH, 20));
        this.registerEntity("botania:fallingStar", new AspectList().add(Aspect.AVERSION, 10).add(Aspect.ELDRITCH, 10).add(Aspect.LIGHT, 5));
    }

    private void registerFlower(String flowerId, AspectList extraAspects) {
        AspectList aspects = extraAspects.copy().add(Aspect.PLANT, 15).add(Aspect.SENSES, 15).add(Aspect.MAGIC, 5);
        AspectList floatingAspects = aspects.copy().add(Aspect.FLIGHT, 5).add(Aspect.LIGHT, 5);
        this.proxy.registerObjectTag(ItemBlockSpecialFlower.ofType(flowerId), aspects);
        this.proxy.registerObjectTag(ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), flowerId), floatingAspects);
        if (BotaniaAPI.miniFlowers.containsKey((Object)flowerId)) {
            String miniFlowerId = (String)BotaniaAPI.miniFlowers.get((Object)flowerId);
            this.proxy.registerObjectTag(ItemBlockSpecialFlower.ofType(miniFlowerId), TCAspects.petiteAspects(aspects));
            this.proxy.registerObjectTag(ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), miniFlowerId), TCAspects.petiteAspects(floatingAspects));
        }
    }

    private static AspectList petiteAspects(AspectList aspects) {
        AspectList list = new AspectList();
        for (Aspect a : aspects.getAspects()) {
            list.add(a, aspects.getAmount(a) / 2 + 1);
        }
        return list;
    }

    private void register(Item item, int meta, AspectList aspects) {
        this.proxy.registerObjectTag(new ItemStack(item, 1, meta), aspects);
    }

    private void register(Block block, int meta, AspectList aspects) {
        this.proxy.registerObjectTag(new ItemStack(block, 1, meta), aspects);
    }

    private void register(String oreDict, AspectList aspects) {
        this.proxy.registerObjectTag(oreDict, aspects);
    }

    private void registerComplex(Item item, int meta, AspectList aspects) {
        this.proxy.registerComplexObjectTag(new ItemStack(item, 1, meta), aspects);
    }

    private void registerComplex(Block block, int meta, AspectList aspects) {
        this.proxy.registerComplexObjectTag(new ItemStack(block, 1, meta), aspects);
    }

    private void registerEntity(String entityName, AspectList aspects) {
        ThaumcraftApi.registerEntityTag((String)entityName, (AspectList)aspects, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }
}

