/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import vazkii.botania.common.core.handler.ConfigHandler;

public class GoGConditionFactory
implements IConditionFactory {
    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        JsonElement element = json.get("value");
        if (!element.isJsonPrimitive()) {
            throw new IllegalArgumentException("Garden of Glass crafting condition must be a primitive");
        }
        JsonPrimitive p = element.getAsJsonPrimitive();
        if (p.isBoolean()) {
            return () -> ConfigHandler.registerGogRecipes == p.getAsBoolean();
        }
        if (p.isString()) {
            String s = p.getAsString();
            if (s.equals("recipes")) {
                return () -> ConfigHandler.registerGogRecipes;
            }
            if (s.equals("resources")) {
                return () -> ConfigHandler.registerGogRecipes && ConfigHandler.registerGogResources;
            }
            throw new IllegalArgumentException("Garden of Glass crafting condition must be boolean, 'recipes' or 'resources'");
        }
        throw new IllegalArgumentException("Garden of Glass crafting condition must be boolean, 'recipes' or 'resources'");
    }
}

