/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class InventoryHelper {
    public static InvWithLocation getInventoryWithLocation(World world, BlockPos pos, EnumFacing side) {
        IItemHandler ret = InventoryHelper.getInventory(world, pos, side);
        if (ret == null) {
            return null;
        }
        return new InvWithLocation(ret, world, pos);
    }

    public static IItemHandler getInventory(World world, BlockPos pos, EnumFacing side) {
        IItemHandler ret;
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        IItemHandler iItemHandler = ret = te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (ret == null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            ret = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return ret;
    }

    public static void dropInventory(TileSimpleInventory inv, World world, IBlockState state, BlockPos pos) {
        if (inv != null) {
            for (int j1 = 0; j1 < inv.getSizeInventory(); ++j1) {
                ItemStack itemstack = inv.getItemHandler().getStackInSlot(j1);
                if (itemstack.func_190926_b()) continue;
                net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
            }
            world.func_175666_e(pos, state.func_177230_c());
        }
    }

    public static void withdrawFromInventory(TileSimpleInventory inv, EntityPlayer player) {
        for (int i = inv.getSizeInventory() - 1; i >= 0; --i) {
            ItemStack stackAt = inv.getItemHandler().getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)copy);
            inv.getItemHandler().setStackInSlot(i, ItemStack.field_190927_a);
            player.field_70170_p.func_175666_e(inv.func_174877_v(), null);
            break;
        }
    }

    public static String stringifyStack(@Nonnull ItemStack s) {
        String itemId = Objects.requireNonNull(s.func_77973_b().getRegistryName()).toString();
        if (s.func_77960_j() != 0) {
            itemId = itemId + "@" + s.func_77960_j();
        }
        return itemId;
    }

    @Nullable
    public static ItemStack destringifyStack(String s) {
        ResourceLocation rl;
        Item it;
        int meta = 0;
        String[] split = s.split("@");
        if (split.length > 1) {
            meta = Integer.parseInt(split[1]);
            s = split[0];
        }
        if ((it = (Item)Item.field_150901_e.func_82594_a((Object)(rl = new ResourceLocation(s)))) != null) {
            return new ItemStack(it, 1, meta);
        }
        return null;
    }

    public static void resizeInventory(ItemStackHandler inv, int newSize) {
        int i;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            stacks.add(stack);
        }
        inv.setSize(newSize);
        for (i = 0; i < newSize && i < stacks.size(); ++i) {
            inv.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }
}

