/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileOrechid
extends SubTileFunctional {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    @Override
    public void onUpdate() {
        ItemStack stack;
        BlockPos coords;
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (this.mana >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && !(stack = this.getOreToPut()).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            int meta = stack.func_77952_i();
            this.supertile.func_145831_w().func_180501_a(coords, block.func_176203_a(meta), 3);
            if (ConfigHandler.blockBreakParticles) {
                this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_149682_b((Block)block) + (meta << 12));
            }
            this.supertile.func_145831_w().func_184133_a(null, this.supertile.func_174877_v(), ModSounds.orechid, SoundCategory.BLOCKS, 2.0f, 1.0f);
            this.mana -= cost;
            this.sync();
        }
    }

    public ItemStack getOreToPut() {
        ArrayList<StringRandomItem> values = new ArrayList<StringRandomItem>();
        Map<String, Integer> map = this.getOreMap();
        for (String s : map.keySet()) {
            values.add(new StringRandomItem(map.get(s), s));
        }
        String ore = ((StringRandomItem)WeightedRandom.func_76271_a((Random)this.supertile.func_145831_w().field_73012_v, values)).s;
        NonNullList ores = OreDictionary.getOres((String)ore);
        for (ItemStack stack : ores) {
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock)) continue;
            return stack;
        }
        return this.getOreToPut();
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.getPos().func_177982_a(-5, -3, -5), (BlockPos)this.getPos().func_177982_a(5, 3, 5))) {
            IBlockState state = this.supertile.func_145831_w().func_180495_p(pos);
            if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)this.supertile.func_145831_w(), pos, this.getReplaceMatcher())) continue;
            possibleCoords.add(pos);
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.supertile.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public Map<String, Integer> getOreMap() {
        return BotaniaAPI.oreWeights;
    }

    public Predicate<IBlockState> getReplaceMatcher() {
        return state -> state.func_177230_c() == Blocks.field_150348_b && state.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.STONE;
    }

    public int getCost() {
        return ConfigHandler.buffedOrechid ? 700 : 17500;
    }

    public int getDelay() {
        return ConfigHandler.buffedOrechid ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 5);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.orechid;
    }

    private static class StringRandomItem
    extends WeightedRandom.Item {
        public final String s;

        public StringRandomItem(int par1, String s) {
            super(par1);
            this.s = s;
        }
    }
}

