/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileBellethorn
extends SubTileFunctional {
    public static final int RANGE = 6;
    public static final int RANGE_MINI = 1;

    @Override
    public int getColor() {
        return 12203041;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        int manaToUse = this.getManaCost();
        if (this.ticksExisted % 5 == 0) {
            int range = this.getRange();
            List entities = this.supertile.func_145831_w().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-range, -range, -range), this.supertile.func_174877_v().func_177982_a(range + 1, range + 1, range + 1)), this.getSelector()::test);
            for (EntityLivingBase entity : entities) {
                if (entity.field_70737_aN != 0 || this.mana < manaToUse) continue;
                int dmg = 4;
                if (entity instanceof EntityWitch) {
                    dmg = 20;
                }
                entity.func_70097_a(DamageSource.field_76376_m, (float)dmg);
                this.mana -= manaToUse;
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getManaCost() {
        return 24;
    }

    public int getRange() {
        return 6;
    }

    public Predicate<Entity> getSelector() {
        return entity -> !(entity instanceof EntityPlayer);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), this.getRange());
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.bellethorne;
    }

    public static class Mini
    extends SubTileBellethorn {
        @Override
        public int getRange() {
            return 1;
        }
    }
}

