/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockTinyPotato
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);

    public BlockTinyPotato() {
        super(Material.field_151580_n, "tinyPotato");
        this.func_149711_c(0.25f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)) {
            case NORTH: {
                return 0;
            }
            case WEST: {
                return 3;
            }
            case EAST: {
                return 1;
            }
        }
        return 2;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing side;
        switch (meta) {
            case 3: {
                side = EnumFacing.WEST;
                break;
            }
            case 0: {
                side = EnumFacing.NORTH;
                break;
            }
            case 1: {
                side = EnumFacing.EAST;
                break;
            }
            default: {
                side = EnumFacing.SOUTH;
            }
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)side);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory(inv, world, state, pos);
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTinyPotato) {
            ((TileTinyPotato)tile).interact(player, hand, player.func_184586_b(hand), par6);
            world.func_175688_a(EnumParticleTypes.HEART, (double)pos.func_177958_n() + BlockTinyPotato.AABB.field_72340_a + Math.random() * (BlockTinyPotato.AABB.field_72336_d - BlockTinyPotato.AABB.field_72340_a), (double)pos.func_177956_o() + BlockTinyPotato.AABB.field_72337_e, (double)pos.func_177952_p() + BlockTinyPotato.AABB.field_72339_c + Math.random() * (BlockTinyPotato.AABB.field_72334_f - BlockTinyPotato.AABB.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        world.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)par5EntityLiving.func_174811_aO().func_176734_d()));
        if (par6ItemStack.func_82837_s()) {
            ((TileTinyPotato)world.func_175625_s((BlockPos)pos)).name = par6ItemStack.func_82833_r();
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            String name = ((TileTinyPotato)tile).name;
            if (!name.isEmpty()) {
                stack.func_151001_c(name);
            }
            list.add((Object)stack);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTinyPotato();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.tinyPotato;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

