/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAltar
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 1.25, 0.875);

    protected BlockAltar() {
        super(Material.field_151576_e, "altar");
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.DEFAULT)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.ALTAR_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((AltarVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTAR_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= AltarVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.values()[meta]));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (te instanceof TileAltar) {
            TileAltar altar = (TileAltar)te;
            if (altar.isMossy) {
                state = state.func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.MOSSY));
            }
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 9; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileAltar tile;
        if (!world.field_72995_K && entity instanceof EntityItem && (tile = (TileAltar)world.func_175625_s(pos)).collideEntityItem((EntityItem)entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return world.func_180495_p(pos).getLightValue(world, pos);
        }
        TileAltar tile = (TileAltar)world.func_175625_s(pos);
        return tile != null && tile.hasLava ? 15 : 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        TileAltar tile = (TileAltar)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            InventoryHelper.withdrawFromInventory(tile, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            return true;
        }
        if (tile.isEmpty() && tile.hasWater && stack.func_190926_b()) {
            tile.trySetLastRecipe(player);
            return true;
        }
        if (!stack.func_190926_b() && (this.isValidWaterContainer(stack) || stack.func_77973_b() == ModItems.waterRod && ManaItemHandler.requestManaExact(stack, player, 75, false))) {
            if (!tile.hasWater) {
                if (stack.func_77973_b() == ModItems.waterRod) {
                    ManaItemHandler.requestManaExact(stack, player, 75, true);
                } else if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, this.drain(FluidRegistry.WATER, stack));
                }
                tile.setWater(true);
                world.func_175666_e(pos, (Block)this);
                world.func_175664_x(pos);
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151129_at) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, this.drain(FluidRegistry.LAVA, stack));
            }
            tile.setLava(true);
            tile.setWater(false);
            world.func_175666_e(pos, (Block)this);
            world.func_175664_x(pos);
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151133_ar && (tile.hasWater || tile.hasLava) && !ConfigHandler.disablePetalApothecaryBucketBehavior) {
            ItemStack bucket;
            ItemStack itemStack = bucket = tile.hasLava ? new ItemStack(Items.field_151129_at) : new ItemStack(Items.field_151131_as);
            if (stack.func_190916_E() == 1) {
                player.func_184611_a(hand, bucket);
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)bucket);
                stack.func_190918_g(1);
            }
            if (tile.hasLava) {
                tile.setLava(false);
            } else {
                tile.setWater(false);
            }
            world.func_175666_e(pos, (Block)this);
            world.func_175664_x(pos);
            return true;
        }
        return false;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity tile;
        if (world.field_73012_v.nextInt(20) == 1 && (tile = world.func_175625_s(pos)) instanceof TileAltar) {
            TileAltar altar = (TileAltar)tile;
            if (!altar.hasLava && !altar.hasWater) {
                altar.setWater(true);
            }
            world.func_175666_e(pos, (Block)this);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    private boolean isValidWaterContainer(ItemStack stack) {
        IFluidHandler handler;
        FluidStack simulate;
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return false;
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (simulate = (handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(new FluidStack(FluidRegistry.WATER, 1000), false)) != null && simulate.getFluid() == FluidRegistry.WATER && simulate.amount == 1000;
    }

    private ItemStack drain(Fluid fluid, ItemStack stack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        handler.drain(new FluidStack(fluid, 1000), true);
        return handler.getContainer();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileAltar();
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory(inv, world, state, pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        return altar.hasWater ? 15 : 0;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.apothecary;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, AltarVariant.values().length - 1);
    }
}

