/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.item.ModItems;

public class AncientWillRecipeWrapper
implements ICustomCraftingRecipeWrapper {
    private final ResourceLocation name;
    private final List<List<ItemStack>> inputs;
    private final List<ItemStack> output;

    public AncientWillRecipeWrapper(AncientWillRecipe recipe) {
        this.name = recipe.getRegistryName();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder helmets = ImmutableList.builder();
        ImmutableList.Builder wills = ImmutableList.builder();
        helmets.add((Object)new ItemStack(ModItems.terrasteelHelm));
        if (Botania.thaumcraftLoaded) {
            helmets.add((Object)new ItemStack(ModItems.terrasteelHelmRevealing));
        }
        for (int i = 0; i < 6; ++i) {
            wills.add((Object)new ItemStack(ModItems.ancientWill, 1, i));
        }
        this.output = helmets.build();
        builder.add(this.output);
        builder.add((Object)wills.build());
        this.inputs = builder.build();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of(this.output));
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        IFocus focus = recipeLayout.getFocus();
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.set(ingredients);
        if (focus != null) {
            ItemStack focused = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT && focused.func_77973_b() == ModItems.ancientWill) {
                group.set(2, new ItemStack(ModItems.ancientWill, 1, focused.func_77960_j()));
                group.set(0, this.getHelmetsWithWill(focused.func_77960_j()));
            } else if (focused.func_77973_b() instanceof IAncientWillContainer) {
                group.set(1, new ItemStack(focused.func_77973_b()));
                group.set(0, this.getWillsOnHelmet(focused.func_77973_b()));
            }
        }
    }

    private List<ItemStack> getHelmetsWithWill(int meta) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack itemStack : this.output) {
            ItemStack toAdd = itemStack.func_77946_l();
            ((IAncientWillContainer)toAdd.func_77973_b()).addAncientWill(toAdd, meta);
            builder.add((Object)toAdd);
        }
        return builder.build();
    }

    private List<ItemStack> getWillsOnHelmet(Item item) {
        if (item instanceof IAncientWillContainer) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = new ItemStack(item);
                ((IAncientWillContainer)item).addAncientWill(stack, i);
                builder.add((Object)stack);
            }
            return builder.build();
        }
        return ImmutableList.of();
    }
}

