/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.tickcentral;

import com.github.terminatornl.laggoggles.Main;
import com.github.terminatornl.laggoggles.tickcentral.Initializer;
import com.github.terminatornl.tickcentral.api.ClassDebugger;
import com.github.terminatornl.tickcentral.api.ClassSniffer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderManagerTransformer
implements IClassTransformer {
    public static final String TRUE_RENDER_TICK = "laggoggles_trueRender";
    public static String NORMAL_RENDER_TICK_NAME;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return basicClass;
        }
        try {
            if (NORMAL_RENDER_TICK_NAME == null) {
                NORMAL_RENDER_TICK_NAME = (String)ClassSniffer.performOnSource((String)"net/minecraft/client/renderer/entity/RenderManager", k -> {
                    ClassNode classNode = new ClassNode();
                    k.accept((ClassVisitor)classNode, 0);
                    for (MethodNode method : classNode.methods) {
                        if (!method.desc.endsWith(";DDDFFZ)V")) continue;
                        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(classNode.name, method.name, method.desc);
                    }
                    throw new IllegalStateException("Did not found the render method in RenderManager!");
                });
                Main.LOGGER.info("Found render tick with name: " + NORMAL_RENDER_TICK_NAME);
            }
            ClassReader reader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            if (transformedName.equals("net.minecraft.client.renderer.entity.RenderManager")) {
                MethodNode newNode = null;
                for (MethodNode method : classNode.methods) {
                    if (!method.desc.endsWith(";DDDFFZ)V")) continue;
                    String targetDesc = "(L" + classNode.name + ";" + method.desc.substring(1);
                    newNode = RenderManagerTransformer.CopyMethodAppearance(method);
                    newNode.instructions = new InsnList();
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(24, 2));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(24, 4));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(24, 6));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(23, 8));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(23, 9));
                    newNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 10));
                    newNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/terminatornl/laggoggles/tickcentral/RenderManagerAdapter", "redirectRenderEntity", targetDesc, false));
                    newNode.instructions.add((AbstractInsnNode)new InsnNode(177));
                    method.name = TRUE_RENDER_TICK;
                }
                classNode.methods.add(newNode);
            } else if (transformedName.equals("com.github.terminatornl.laggoggles.tickcentral.RenderManagerAdapter")) {
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("redirectRenderEntity")) continue;
                    Initializer.renameTargetInstruction(NORMAL_RENDER_TICK_NAME, TRUE_RENDER_TICK, method.instructions);
                }
            } else {
                return basicClass;
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return ClassDebugger.WriteClass((ClassNode)classNode, (String)transformedName);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Main.LOGGER.fatal("Something went wrong!", e);
            FMLCommonHandler.instance().exitJava(1, false);
            throw new RuntimeException(e);
        }
    }

    public static MethodNode CopyMethodAppearance(MethodNode node) {
        MethodNode newNode = new MethodNode();
        newNode.access = node.access;
        newNode.name = node.name;
        newNode.desc = node.desc;
        newNode.signature = node.signature;
        newNode.parameters = node.parameters == null ? null : RenderManagerTransformer.CopyParameterNodes(node.parameters);
        newNode.exceptions = new LinkedList(node.exceptions);
        newNode.attrs = node.attrs == null ? null : new LinkedList(node.attrs);
        return newNode;
    }

    @Nonnull
    public static List<ParameterNode> CopyParameterNodes(@Nonnull List<ParameterNode> nodes) {
        LinkedList<ParameterNode> list = new LinkedList<ParameterNode>();
        for (ParameterNode node : nodes) {
            list.add(RenderManagerTransformer.CopyParameterNode(node));
        }
        return list;
    }

    public static ParameterNode CopyParameterNode(ParameterNode node) {
        return new ParameterNode(node.name, node.access);
    }
}

