/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.tickcentral;

import com.github.terminatornl.laggoggles.profiler.ProfileManager;
import com.github.terminatornl.laggoggles.tickcentral.Initializer;
import com.github.terminatornl.tickcentral.api.ClassDebugger;
import java.lang.reflect.Field;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventBusTransformer
implements IClassTransformer {
    public static final Field ownerField;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || !transformedName.equals("net.minecraftforge.fml.common.eventhandler.EventBus")) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            Initializer.convertTargetInstruction("net/minecraftforge/fml/common/eventhandler/IEventListener", "invoke", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)V", this.getClass().getName().replace(".", "/"), "redirectEvent", "(Lnet/minecraftforge/fml/common/eventhandler/IEventListener;Lnet/minecraftforge/fml/common/eventhandler/Event;)V", 184, method.instructions);
        }
        try {
            return ClassDebugger.WriteClass((ClassNode)classNode, (String)transformedName);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void redirectEvent(IEventListener listener, Event event) {
        if (!ProfileManager.PROFILER_ENABLED_UPDATE_SAFE) {
            listener.invoke(event);
            return;
        }
        long start = System.nanoTime();
        listener.invoke(event);
        long nanos = System.nanoTime() - start;
        if (listener instanceof ASMEventHandler) {
            String identifier;
            try {
                ModContainer container = (ModContainer)ownerField.get(listener);
                identifier = container.getName() + " (" + container.getSource().getName() + ")";
            }
            catch (IllegalAccessException e) {
                identifier = "Unknown: " + listener.hashCode();
            }
            ProfileManager.timingManager.addEventTime(identifier, event, nanos);
        }
    }

    static {
        try {
            ownerField = ASMEventHandler.class.getDeclaredField("owner");
            ownerField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

