/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.profiler;

import com.github.terminatornl.laggoggles.CommonProxy;
import com.github.terminatornl.laggoggles.Main;
import com.github.terminatornl.laggoggles.api.event.LagGogglesEvent;
import com.github.terminatornl.laggoggles.client.FPSCounter;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.packet.SPacketProfileStatus;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.profiler.TickCounter;
import com.github.terminatornl.laggoggles.profiler.TimingManager;
import com.github.terminatornl.laggoggles.util.Graphical;
import com.github.terminatornl.laggoggles.util.Perms;
import com.github.terminatornl.laggoggles.util.RunInClientThread;
import com.github.terminatornl.laggoggles.util.RunInServerThread;
import com.github.terminatornl.laggoggles.util.Side;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ProfileManager {
    public static TimingManager timingManager = new TimingManager();
    public static final AtomicReference<ProfileResult> LAST_PROFILE_RESULT = new AtomicReference();
    public static final Object LOCK = new Object();
    private static final FPSCounter FPS_COUNTER = new FPSCounter();
    public static boolean PROFILER_ENABLED_UPDATE_SAFE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileResult runProfiler(int seconds, ScanType type, ICommandSender issuer) throws IllegalStateException {
        try {
            if (PROFILER_ENABLED_UPDATE_SAFE) {
                throw new IllegalStateException("Can't start profiler when it's already running!");
            }
            SPacketProfileStatus status = new SPacketProfileStatus(true, seconds, issuer.func_70005_c_());
            new RunInServerThread(() -> {
                for (EntityPlayerMP user : Perms.getLagGogglesUsers()) {
                    CommonProxy.sendTo(status, user);
                }
            });
            issuer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "LagGoggles" + TextFormatting.WHITE + ": Profiler started for " + seconds + " seconds."));
            Main.LOGGER.info("LagGoggles profiler started by " + issuer.func_70005_c_() + " (" + seconds + " seconds)");
            long start = System.nanoTime();
            TickCounter.ticks.set(0L);
            timingManager = new TimingManager();
            if (Side.getSide().isClient()) {
                FPS_COUNTER.start();
            }
            MinecraftForge.EVENT_BUS.register(new Object(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @SubscribeEvent
                protected void onTick(TickEvent e) {
                    Object object = LOCK;
                    synchronized (object) {
                        PROFILER_ENABLED_UPDATE_SAFE = true;
                        LOCK.notify();
                    }
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            });
            Object object = LOCK;
            synchronized (object) {
                while (!PROFILER_ENABLED_UPDATE_SAFE) {
                    LOCK.wait();
                }
            }
            Thread.sleep(seconds * 1000);
            object = LOCK;
            synchronized (object) {
                PROFILER_ENABLED_UPDATE_SAFE = false;
            }
            long frames = FPS_COUNTER.stop();
            Runnable task = () -> {
                try {
                    ArrayList<Entity> ignoredEntities = new ArrayList<Entity>();
                    ArrayList<Entity> ignoredTileEntities = new ArrayList<Entity>();
                    ArrayList<UUID> ignoredBlocks = new ArrayList<UUID>();
                    Main.LOGGER.info("Processing results synchronously...");
                    ProfileResult result = new ProfileResult(start, System.nanoTime(), TickCounter.ticks.get(), Side.getSide(), type);
                    if (Side.getSide().isClient()) {
                        result.setFrames(frames);
                    }
                    for (Map.Entry<Integer, TimingManager.WorldData> entry : timingManager.getTimings().entrySet()) {
                        Entity e;
                        int worldID = entry.getKey();
                        WorldServer world = DimensionManager.getWorld((int)worldID);
                        if (world == null) continue;
                        for (Map.Entry<UUID, Long> entry2 : entry.getValue().getEntityTimes().entrySet()) {
                            e = world.func_175733_a(entry2.getKey());
                            if (e == null) continue;
                            try {
                                result.addData(new ObjectData(worldID, e.func_70005_c_(), Graphical.formatClassName(e.getClass().toString()), e.getPersistentID(), (long)entry2.getValue(), ObjectData.Type.ENTITY));
                            }
                            catch (Throwable t) {
                                ignoredEntities.add(e);
                            }
                        }
                        for (Map.Entry<UUID, Long> entry3 : entry.getValue().getBlockTimes().entrySet()) {
                            if (!world.func_175667_e((BlockPos)entry3.getKey())) continue;
                            e = world.func_175625_s((BlockPos)entry3.getKey());
                            if (e != null) {
                                try {
                                    ITextComponent displayName = e.func_145748_c_();
                                    String name = displayName != null ? displayName.func_150254_d() : e.getClass().getSimpleName();
                                    result.addData(new ObjectData(worldID, name, Graphical.formatClassName(e.getClass().toString()), e.func_174877_v(), (long)entry3.getValue(), ObjectData.Type.TILE_ENTITY));
                                }
                                catch (Throwable t) {
                                    ignoredTileEntities.add(e);
                                }
                                continue;
                            }
                            try {
                                IBlockState state = world.func_180495_p((BlockPos)entry3.getKey());
                                String name = state.func_177230_c().func_149732_F();
                                result.addData(new ObjectData(worldID, name, Graphical.formatClassName(state.func_177230_c().getClass().toString()), (BlockPos)entry3.getKey(), (long)entry3.getValue(), ObjectData.Type.BLOCK));
                            }
                            catch (Throwable t) {
                                ignoredBlocks.add(entry3.getKey());
                            }
                        }
                    }
                    for (Map.Entry<Object, Object> entry : timingManager.getEventTimings().entrySet()) {
                        result.addData(new ObjectData((TimingManager.EventTimings)entry.getKey(), ((AtomicLong)entry.getValue()).get()));
                    }
                    if (result.getSide().isClient()) {
                        ProfileManager.insertGuiData(result, timingManager);
                    }
                    result.lock();
                    LAST_PROFILE_RESULT.set(result);
                    Object object = LOCK;
                    synchronized (object) {
                        LOCK.notifyAll();
                    }
                    if (ignoredBlocks.size() + ignoredEntities.size() + ignoredTileEntities.size() > 0) {
                        Main.LOGGER.info("Ignored some tracked elements:");
                        Main.LOGGER.info("Entities: " + ignoredEntities);
                        Main.LOGGER.info("Tile entities: " + ignoredTileEntities);
                        Main.LOGGER.info("Blocks in locations: " + ignoredBlocks);
                    }
                }
                catch (Throwable e) {
                    Main.LOGGER.error("Woa! Something went wrong while processing results! Please contact Terminator_NL and submit the following error in an issue at github!");
                    e.printStackTrace();
                }
            };
            Side side = Side.getSide();
            if (side.isServer()) {
                new RunInServerThread(task);
            } else if (side.isClient()) {
                new RunInClientThread(task);
            } else {
                Main.LOGGER.error("LagGoggles did something amazing. I have no clue how this works, but here's a stacktrace, please submit an issue at github with the stacktrace below!");
                Thread.dumpStack();
            }
            Object object2 = LOCK;
            synchronized (object2) {
                LOCK.wait();
            }
            MinecraftForge.EVENT_BUS.post((Event)new LagGogglesEvent.LocalResult(LAST_PROFILE_RESULT.get()));
            Main.LOGGER.info("Profiling complete.");
            issuer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "LagGoggles" + TextFormatting.WHITE + ": Profiling complete."));
            return LAST_PROFILE_RESULT.get();
        }
        catch (Throwable e) {
            Main.LOGGER.error("Woa! Something went wrong while processing results! Please contact Terminator_NL and submit the following error in an issue at github!");
            e.printStackTrace();
            return null;
        }
    }

    public static void insertGuiData(ProfileResult result, TimingManager timings) {
        TreeMap<UUID, Long> entityTimes = timings.getGuiEntityTimings();
        for (Entity e : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            Long time = entityTimes.get(e.func_110124_au());
            if (time == null) continue;
            result.addData(new ObjectData(e.field_70170_p.field_73011_w.getDimension(), e.func_70005_c_(), Graphical.formatClassName(e.getClass().toString()), e.getPersistentID(), (long)time, ObjectData.Type.GUI_ENTITY));
        }
        TreeMap<BlockPos, Long> blockTimes = timings.getGuiBlockTimings();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (Map.Entry<BlockPos, Long> e : blockTimes.entrySet()) {
            Long time = e.getValue();
            TileEntity entity = world.func_175625_s(e.getKey());
            if (entity != null) {
                ITextComponent displayName = entity.func_145748_c_();
                String name = displayName != null ? displayName.func_150254_d() : entity.getClass().getSimpleName();
                result.addData(new ObjectData(entity.func_145831_w().field_73011_w.getDimension(), name, Graphical.formatClassName(entity.getClass().toString()), entity.func_174877_v(), (long)time, ObjectData.Type.GUI_BLOCK));
                continue;
            }
            IBlockState state = world.func_180495_p(e.getKey());
            String name = state.func_177230_c().func_149732_F();
            result.addData(new ObjectData(world.field_73011_w.getDimension(), name, Graphical.formatClassName(state.func_177230_c().getClass().toString()), e.getKey(), (long)time, ObjectData.Type.GUI_BLOCK));
        }
    }
}

