/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.packet;

import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.util.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SPacketScanResult
implements IMessage {
    public ArrayList<ObjectData> DATA = new ArrayList();
    public boolean hasMore = false;
    public long startTime;
    public long endTime;
    public long totalTime;
    public long tickCount;
    public Side side;
    public ScanType type;
    public long totalFrames = 0L;

    public void fromBytes(ByteBuf buf) {
        this.tickCount = buf.readLong();
        this.hasMore = buf.readBoolean();
        this.endTime = buf.readLong();
        this.startTime = buf.readLong();
        this.totalTime = buf.readLong();
        this.totalFrames = buf.readLong();
        this.side = Side.values()[buf.readInt()];
        this.type = ScanType.values()[buf.readInt()];
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ObjectData data = new ObjectData();
            data.fromBytes(buf);
            this.DATA.add(data);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.tickCount);
        buf.writeBoolean(this.hasMore);
        buf.writeLong(this.endTime);
        buf.writeLong(this.startTime);
        buf.writeLong(this.totalTime);
        buf.writeLong(this.totalFrames);
        buf.writeInt(this.side.ordinal());
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.DATA.size());
        for (ObjectData data : this.DATA) {
            data.toBytes(buf);
        }
    }
}

