/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.gen;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenDungeon;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenIsland;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenIslandStub;
import com.gildedgames.the_aether.world.util.RandomTracker;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenGoldenDungeon
extends MapGenStructure {
    public String func_143025_a() {
        return "GoldDungeon";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        int j = pos.func_177958_n() >> 4;
        int k = pos.func_177952_p() >> 4;
        for (int l = 0; l <= 1000; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    int l1;
                    int k1;
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1 || !this.func_75047_a(k1 = j + i1, l1 = k + j1) || findUnexplored && worldIn.func_190526_b(k1, l1)) continue;
                    return new BlockPos((k1 << 4) + 8, 64, (l1 << 4) + 8);
                }
            }
        }
        return null;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        RandomTracker randomTracker = new RandomTracker();
        if (randomTracker.testRandom(this.field_75038_b, AetherConfig.world_gen.golden_dungeon_primary_chance) != 0 && randomTracker.testRandom(this.field_75038_b, AetherConfig.world_gen.golden_dungeon_secondary_chance) != 0) {
            return false;
        }
        return chunkX % 10 == 0 && chunkZ % 10 == 0;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private final Set<ChunkPos> processed = Sets.newHashSet();
        private boolean wasCreated;
        private int dungeonDirection;
        private int stubIslandCount;

        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, random, chunkX, chunkZ);
        }

        private void create(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            ComponentGoldenIsland dungeon = new ComponentGoldenIsland((chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.dungeonDirection = random.nextInt(4);
            this.stubIslandCount = 8 + random.nextInt(5);
            this.field_75075_a.add(dungeon);
            for (int stubIslands = 0; stubIslands < this.stubIslandCount; ++stubIslands) {
                float f1 = 0.01745329f;
                float f2 = random.nextFloat() * 360.0f;
                float f3 = (random.nextFloat() * 0.125f + 0.7f) * 24.0f;
                int l4 = MathHelper.func_76128_c((double)(Math.cos(f1 * f2) * (double)f3));
                int k5 = -MathHelper.func_76128_c((double)(24.0 * (double)random.nextFloat() * 0.3));
                int i6 = MathHelper.func_76128_c((double)(-Math.sin(f1 * f2) * (double)f3));
                this.field_75075_a.add(new ComponentGoldenIslandStub((chunkX << 4) + 2, (chunkZ << 4) + 2, l4, k5, i6, 8));
            }
            this.field_75075_a.add(new ComponentGoldenDungeon((chunkX << 4) + 2, (chunkZ << 4) + 2, this.dungeonDirection));
            this.customOffset(random);
            this.func_75072_c();
            this.wasCreated = true;
        }

        private void customOffset(Random random) {
            int offset = random.nextInt(64);
            for (StructureComponent component : this.field_75075_a) {
                component.func_181138_a(0, offset, 0);
            }
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            if (!this.wasCreated) {
                this.field_75075_a.clear();
                this.create(worldIn, rand, this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(worldIn, rand, structurebb);
        }

        public boolean func_175788_a(ChunkPos pair) {
            return this.processed.contains(pair) ? false : super.func_175788_a(pair);
        }

        public void func_175787_b(ChunkPos pair) {
            super.func_175787_b(pair);
            this.processed.add(pair);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (ChunkPos chunkpos : this.processed) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("X", chunkpos.field_77276_a);
                nbttagcompound.func_74768_a("Z", chunkpos.field_77275_b);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            tagCompound.func_74782_a("Processed", (NBTBase)nbttaglist);
            tagCompound.func_74768_a("stubIslandCount", this.stubIslandCount);
            tagCompound.func_74768_a("dungeonDirection", this.dungeonDirection);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            if (tagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nbttaglist = tagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.processed.add(new ChunkPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Z")));
                }
            }
            this.stubIslandCount = tagCompound.func_74762_e("stubIslandCount");
            this.dungeonDirection = tagCompound.func_74762_e("dungeonDirection");
        }
    }
}

