/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive.mountable;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.entities.util.EntitySaddleMount;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.registry.AetherLootTables;
import com.gildedgames.the_aether.registry.sounds.SoundsAether;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityFlyingCow
extends EntitySaddleMount {
    public float wingFold;
    public float wingAngle;
    private float aimingForFold;
    public int maxJumps;
    public int jumpsRemaining;
    private int ticks;

    public EntityFlyingCow(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.4f);
        this.ticks = 0;
        this.maxJumps = 1;
        this.jumpsRemaining = 0;
        this.field_70138_W = 1.0f;
        this.field_70158_ak = true;
        this.canJumpMidAir = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blue_berry, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        if (this.getSaddled()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70122_E) {
            this.wingAngle *= 0.8f;
            this.aimingForFold = 0.1f;
            this.jumpsRemaining = this.maxJumps;
        } else {
            this.aimingForFold = 1.0f;
        }
        ++this.ticks;
        this.wingAngle = this.wingFold * (float)Math.sin((float)this.ticks / 31.830988f);
        this.wingFold += (this.aimingForFold - this.wingFold) / 5.0f;
        this.field_70143_R = 0.0f;
        this.fall();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Jumps", (short)this.maxJumps);
        nbttagcompound.func_74777_a("Remaining", (short)this.jumpsRemaining);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.maxJumps = nbttagcompound.func_74765_d("Jumps");
        this.jumpsRemaining = nbttagcompound.func_74765_d("Remaining");
    }

    public double func_70042_X() {
        return 1.15;
    }

    @Override
    public float getMountedMoveSpeed() {
        return 0.3f;
    }

    protected void func_70664_aZ() {
        if (this.func_184188_bt().isEmpty()) {
            super.func_70664_aZ();
        }
    }

    private void fall() {
        if (!this.field_70122_E) {
            if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
                this.field_70181_x *= 0.6;
            }
            if (this.field_70122_E) {
                this.jumpsRemaining = this.maxJumps;
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack currentStack = player.func_184586_b(hand);
        if (currentStack.func_77973_b() == Items.field_151133_ar) {
            Item milk = Items.field_151117_aB;
            if (currentStack.func_190916_E() == 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(milk));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(milk))) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(milk)));
                    if (!player.field_71075_bZ.field_75098_d) {
                        currentStack.func_190918_g(1);
                    }
                }
            } else if (!player.field_71075_bZ.field_75098_d) {
                currentStack.func_190918_g(1);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.spawnrates.flyingcow_spawnrate) == 0 && super.func_70601_bi();
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.flyingcow_say;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.flyingcow_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.flyingcow_death;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.3f;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block par4) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187566_ao, SoundCategory.NEUTRAL, 0.15f, 1.0f);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntityFlyingCow(this.field_70170_p);
    }

    @Override
    protected double getMountJumpStrength() {
        return 5.0;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AetherLootTables.flying_cow;
    }
}

