/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.transmutator;

import com.google.common.collect.ImmutableList;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityTransmutator;
import com.shinoow.abyssalcraft.integration.jei.JEIUtils;
import com.shinoow.abyssalcraft.integration.jei.transmutator.TransmutatorFuelRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class TransmutatorFuelRecipeMaker {
    @Nonnull
    public static List<TransmutatorFuelRecipe> getFuelRecipes(JEIUtils itemRegistry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        ImmutableList<ItemStack> fuelStacks = itemRegistry.getTransmutatorFuels();
        HashSet<String> oreDictNames = new HashSet<String>();
        ArrayList<TransmutatorFuelRecipe> fuelRecipes = new ArrayList<TransmutatorFuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            int burnTime;
            if (fuelStack == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)fuelStack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    int burnTime2;
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    NonNullList oreDictFuels = OreDictionary.getOres((String)name);
                    List oreDictFuelsSet = stackHelper.getAllSubtypes((Iterable)oreDictFuels);
                    TransmutatorFuelRecipeMaker.removeNoBurnTime(oreDictFuelsSet);
                    if (oreDictFuelsSet.isEmpty() || (burnTime2 = TransmutatorFuelRecipeMaker.getBurnTime((ItemStack)oreDictFuelsSet.get(0))) <= 0) continue;
                    fuelRecipes.add(new TransmutatorFuelRecipe(guiHelper, oreDictFuelsSet, burnTime2));
                }
                continue;
            }
            List subtypes = stackHelper.getSubtypes(fuelStack);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (ItemStack subtype : subtypes) {
                if (TileEntityTransmutator.getItemBurnTime(subtype) <= 0) continue;
                fuels.add(subtype);
            }
            if (fuels.isEmpty() || (burnTime = TransmutatorFuelRecipeMaker.getBurnTime((ItemStack)fuels.get(0))) <= 0) continue;
            fuelRecipes.add(new TransmutatorFuelRecipe(guiHelper, fuels, burnTime));
        }
        return fuelRecipes;
    }

    private static void removeNoBurnTime(Collection<ItemStack> itemStacks) {
        itemStacks.removeIf(stack -> TransmutatorFuelRecipeMaker.getBurnTime(stack) == 0);
    }

    private static int getBurnTime(ItemStack itemStack) {
        return TileEntityTransmutator.getItemBurnTime(itemStack);
    }
}

